<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use \App\Models\User;
use \App\Models\Ponto;
use \App\Models\Tablet;
use \App\Models\Cliente;
use \App\Models\Credito;
use \App\Models\Leitura;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\ClientException;
use Illuminate\Http\Response;
use Hash;
use Session;
use DateTime;
use DateInterval;

class PixController extends Controller
{
    public function gerarPix(Request $request)
    {
        $dateTime = new DateTime();
        $dateTime->add(new DateInterval('PT5M'));
        // Asaas aceita data (YYYY-MM-DD) para dueDate; evite horário
        $formattedDueDate = $dateTime->format('Y-m-d');

        $client = new \GuzzleHttp\Client();

        if ($request->token == "app") {
            $nome = $request->nome;
            $idprod = $request->idprod;
            $cpf = str_replace(['.', '-'], '', $request->cpf);
            $valor = $request->valor;
        } else {
            $nome = $request->input('user.nome');
            $idprod = $request->input('user.tablet.idprod');
            $cpf = str_replace(['.', '-'], '', $request->input('user.cpf'));
            $valor = $request->input('deposito.valor');
        }

        $user = User::find($request->cliente_id);

        $c_id = $user->cpf;
        $s_id = $user->chave_pix;

        // Garante ponto decimal (e não vírgula) e tipo numérico
        $valorCobranca = (float) number_format((float) $valor, 2, '.', '');

        $sandbox = false;

        $data = [
            // 'customer' => 'cus_000074096837', // garanta que é do mesmo ambiente do token
            'customer' =>  $s_id,
            // 'customer' => 'cus_000126838891', // garanta que é do mesmo ambiente do token may
            // 'customer' => 'cus_000005810756', // garanta que é do mesmo ambiente do token sandbox
            // 'customer' => 'cus_000005810756', // garanta que é do mesmo ambiente do token sandbox
            'billingType' => 'PIX',
            'value' => $valorCobranca,
            'dueDate' => $formattedDueDate,   // opcional p/ PIX; se quiser, pode remover
            'description' => $idprod,
        ];

        try {
            // evita que POST vire GET em redirect por URL incorreta
            $response = $client->request('POST', rtrim(urlApi($sandbox), '/') . '/payments', [
                'headers' => [
                    'accept' => 'application/json',
                    'content-type' => 'application/json',
                    'access_token' => $c_id,
                ],
                'json' => $data,
                'allow_redirects' => false,    // <— crítico
            ]);

            echo $response->getBody();

        } catch (\GuzzleHttp\Exception\ClientException $e) {
            $response = $e->getResponse();
            $statusCode = $response?->getStatusCode();
            $conteudo = $response?->getBody()?->getContents();
            echo $conteudo ?: (string) $e;
        } catch (\Exception $e) {
            echo (string) $e;
        }
    }

    public function gerarPixSuitPay(Request $request)
    {
        $client = new \GuzzleHttp\Client();
        $dateTime = new DateTime();

        // Adicionar 5 minutos
        $dateTime->add(new DateInterval('PT5M'));

        // Formatar a data e hora
        // $formattedDateTime = $dateTime->format('Y-m-d H:i:s');
        $formattedDateTime = $dateTime->format('Y-m-d');



        if ($request->token == "app") {
            $nome = $request->nome;
            $idprod = $request->idprod;
            $cpf = str_replace('.', '', $request->cpf);
            $cpf = str_replace('-', '', $cpf);
            $valor = $request->valor;

            // echo $valor . $cpf . $idprod;
            // return;
        } else {
            $nome = $request->input('user.nome');
            $idprod = $request->input('user.tablet.idprod');
            $cpf = str_replace('.', '', $request->input('user.cpf'));
            $cpf = str_replace('-', '', $cpf);
            $valor = $request->input('deposito.valor');
        }

        $user = User::find($request->cliente_id);

        $c_id = $user->cpf;
        $s_id = $user->chave_pix;

        // echo $c_id;
        // echo "<br>";
        // echo $s_id;
        // return

        //$valorCobranca =number_format($valor,'2');
        $sandbox = true;

        $data = [
            'requestNumber' => $idprod,
            'dueDate' => $formattedDateTime,
            'amount' => $valor,
            'shippingAmount' => 0.0,
            'discountAmount' => 0.0,
            'callbackUrl' => 'https://admin2.pixbetmaster.com.br/public/api/pix/webhook-suit-pay',
            'client' => [
                'name' => $nome,
                'document' => '35077529809',
            ],

        ];

        try {
            $response = $client->request('POST', urlSuitPay($sandbox) . '/api/v1/gateway/request-qrcode', [
                'headers' => [
                    'accept' => 'application/json',
                    'ci' => $c_id,
                    'cs' => $s_id,
                    'content-type' => 'application/json',
                ],
                'json' => $data,
            ]);


            echo $response->getBody();


        } catch (\Exception $e) {
            echo $e;
        } catch (ClientException $e) {
            $response = $e->getResponse();
            $statusCode = $response->getStatusCode();
            $conteudo = $response->getBody()->getContents();
        }
    }

    public function gerarQRCode(Request $request)
    {
        $client = new \GuzzleHttp\Client();

        $sandbox = false;

        $id = $request->input('id');

        $response = $client->request('GET', urlApi($sandbox) . 'payments/' . $id . '/pixQrCode', [
            'headers' => [
                'accept' => 'application/json',
                'access_token' => access_token($sandbox),
            ],

        ]);

        echo $response->getBody();
    }

    // public function transferirPix(Request $request)
    // {
    //     // 1) Normalização: aceita tanto typeKey/typekey quanto key/keyPix (compatível com Unity em produção)
    //     $token = $request->input('token'); // "app" ou "web"
    //     $typeKey = $request->input('typeKey', $request->input('typekey')); // aceita camelCase e lower
    //     $key = $request->input('key', $request->input('keyPix'));      // aceita key e keyPix
    //     $value = $request->input('value');                                // Unity manda "value"
    //     $idprod = $request->input('idprod');                               // Unity manda "idprod"
    //     $cpf = $request->input('cpf');                                  // se o app enviar, usamos; se não, segue sem

    //     // 2) Validação leve (não quebra compat): só garante que temos o mínimo para a API
    //     //    Ajuste a lista de tipos caso seu provedor aceite outros.
    //     $validator = \Validator::make([
    //         'token' => $token,
    //         'typeKey' => $typeKey,
    //         'key' => $key,
    //         'value' => $value,
    //         'idprod' => $idprod,
    //     ], [
    //         'token' => 'required|in:app,web',
    //         'typeKey' => 'required|string',
    //         'key' => 'required|string|max:255',
    //         'value' => 'required|numeric|min:0.01',
    //         'idprod' => 'required',
    //     ]);

    //     if ($validator->fails()) {
    //         return response()->json(['errors' => $validator->errors()], 422);
    //     }

    //     // 3) Mapeamento: CELULAR -> PHONE (back-end corrige se app mandar "CELULAR")
    //     $typeKey = strtoupper($typeKey);
    //     if ($typeKey === 'CELULAR') {
    //         $typeKey = 'PHONE';
    //     }

    //     // 4) (Opcional) Buscar cliente se token = app e cpf veio — mantém compatibilidade
    //     if ($token === 'app' && $cpf) {
    //         $cliente = Cliente::where('cpf', $cpf)->first();
    //         // se precisar validar existência, faça aqui (não obrigatório)
    //     }

    //     $sandbox = false;

    //     $payload = [
    //         'value' => (float) $value,
    //         'operationType' => 'PIX',
    //         'pixAddressKey' => $key,
    //         'pixAddressKeyType' => $typeKey,
    //         'description' => 'assistência remoto',
    //     ];

    //     try {
    //         $client = new \GuzzleHttp\Client();

    //         $response = $client->request('POST', urlApi($sandbox) . 'transfers', [
    //             'headers' => [
    //                 'accept' => 'application/json',
    //                 'access_token' => access_token($sandbox),
    //                 'content-type' => 'application/json',
    //             ],
    //             'json' => $payload,
    //             'timeout' => 20,
    //         ]);

    //         // 5) Atualiza crédito sem travar o fluxo caso não exista (compatível com DB atual)
    //         //    OBS: Aqui NÃO fazemos cast — se idprod no BD é string, funciona; se for int, e $idprod for numérico, também funciona.
    //         if (!empty($idprod)) {
    //             $credito = Credito::where('idprod', $idprod)->first();
    //             if ($credito) {
    //                 // Se isso for taxa ou débito, use número negativo de verdade:
    //                 $credito->valor = -7.00;
    //                 $credito->save();
    //             }
    //         }

    //         // 6) Devolvemos ao app a resposta do provedor (como já era)
    //         return response((string) $response->getBody(), 200);

    //     } catch (\GuzzleHttp\Exception\ClientException $e) {
    //         // Erro 4xx do provedor
    //         $body = (string) $e->getResponse()->getBody();
    //         $json = json_decode($body);
    //         $desc = $json->errors[0]->description ?? $body;
    //         return response()->json($desc, 400);

    //     } catch (\GuzzleHttp\Exception\RequestException $e) {
    //         // Timeout/conexão
    //         return response()->json('Falha de comunicação com o provedor PIX: ' . $e->getMessage(), 502);

    //     } catch (\Throwable $e) {
    //         // Qualquer outro erro
    //         return response()->json('Falha na transferência PIX: ' . $e->getMessage(), 500);
    //     }
    // }



    public function transferirPix(Request $request)
    {
        // 1) Normalização: aceita tanto typeKey/typekey quanto key/keyPix (compatível com Unity em produção)
        $token = $request->input('token'); // "app" ou "web"
        $typeKey = $request->input('typeKey', $request->input('typekey')); // aceita camelCase e lower
        $key = $request->input('key', $request->input('keyPix'));      // aceita key e keyPix
        $value = $request->input('value');                                // Unity manda "value"
        $idprod = $request->input('idprod');                               // Unity manda "idprod"
        $cpf = $request->input('cpf');                                  // se o app enviar, usamos; se não, segue sem

        // 2) Validação leve (não quebra compat): só garante que temos o mínimo para a API
        $validator = \Validator::make([
            'token' => $token,
            'typeKey' => $typeKey,
            'key' => $key,
            'value' => $value,
            'idprod' => $idprod,
        ], [
            'token' => 'required|in:app,web',
            'typeKey' => 'required|string',
            'key' => 'required|string|max:255',
            'value' => 'required|numeric|min:0.01',
            'idprod' => 'required',
        ]);

        if ($validator->fails()) {
            // devolve APENAS TEXTO (primeira mensagem) para a Unity mostrar sem escapes
            $msg = $validator->errors()->first();
            return response($msg, 422)->header('Content-Type', 'text/plain; charset=utf-8');
        }

        // 3) Mapeamento: CELULAR -> PHONE (back-end corrige se app mandar "CELULAR")
        $typeKey = strtoupper($typeKey);
        if ($typeKey === 'CELULAR') {
            $typeKey = 'PHONE';
        }

        // 4) (Opcional) Buscar cliente se token = app e cpf veio — mantém compatibilidade
        if ($token === 'app' && $cpf) {
            $cliente = Cliente::where('cpf', $cpf)->first();
            // se precisar validar existência, faça aqui (não obrigatório)
        }

        $sandbox = false;

        $payload = [
            'value' => (float) $value,
            'operationType' => 'PIX',
            'pixAddressKey' => $key,
            'pixAddressKeyType' => $typeKey,
            'description' => 'assistência remoto',
        ];

        try {
            $client = new \GuzzleHttp\Client();

            $response = $client->request('POST', urlApi($sandbox) . 'transfers', [
                'headers' => [
                    'accept' => 'application/json',
                    'access_token' => access_token($sandbox),
                    'content-type' => 'application/json',
                ],
                'json' => $payload,
                'timeout' => 20,
            ]);

            // 5) Atualiza crédito sem travar o fluxo caso não exista (compatível com DB atual)
            if (!empty($idprod)) {
                $credito = Credito::where('idprod', $idprod)->first();
                if ($credito) {
                    $credito->valor = -7.00; // número negativo real
                    $credito->save();
                }
            }

            // 6) Sucesso: repassa o corpo E o content-type do Asaas
            $body = (string) $response->getBody();
            $contentType = $response->hasHeader('Content-Type')
                ? $response->getHeaderLine('Content-Type')
                : 'application/json; charset=utf-8';

            return response($body, 200)->header('Content-Type', $contentType);

        } catch (\GuzzleHttp\Exception\ClientException $e) {
            // Erro 4xx do provedor: extrai errors[0].description | message | description
            $resp = $e->getResponse();
            $body = $resp ? (string) $resp->getBody() : '';

            $desc = null;
            if ($body !== '') {
                $decoded = json_decode($body, true);

                if (json_last_error() === JSON_ERROR_NONE) {
                    if (is_string($decoded)) {
                        $desc = $decoded; // caso venha como "string JSON"
                    } elseif (is_array($decoded)) {
                        if (!empty($decoded['errors'][0]['description'])) {
                            $desc = $decoded['errors'][0]['description'];
                        } elseif (!empty($decoded['description'])) {
                            $desc = $decoded['description'];
                        } elseif (!empty($decoded['message'])) {
                            $desc = $decoded['message'];
                        }
                    }
                }

                // fallback: se veio "\"texto\"" remove aspas externas
                if ($desc === null && strlen($body) >= 2 && $body[0] === '"' && substr($body, -1) === '"') {
                    $desc = stripcslashes(substr($body, 1, -1));
                }
            }

            if ($desc === null) {
                $desc = 'Falha na transferência (requisição inválida).';
            }

            // **TEXTO PURO** para a Unity mostrar sem \u00xx
            return response($desc, 400)->header('Content-Type', 'text/plain; charset=utf-8');

        } catch (\GuzzleHttp\Exception\RequestException $e) {
            // Timeout/conexão
            return response('Falha de comunicação com o provedor PIX.', 502)
                ->header('Content-Type', 'text/plain; charset=utf-8');

        } catch (\Throwable $e) {
            // Qualquer outro erro
            return response('Falha na transferência PIX.', 500)
                ->header('Content-Type', 'text/plain; charset=utf-8');
        }
    }
    public function transferirPixSuitPay(Request $request)
    {
        $client = new \GuzzleHttp\Client();
        //dd($request->all());
        $key = $request->input('key');
        $typeKey = $request->input('typeKey');
        $value = number_format($request->input('value'), '2');
        $idprod = $request->input('idprod');
        $userId = $request->input('cliente_id');

        if ($typeKey == 'CPF/CNPJ') {
            $typeKey = 'document';
        } else if ($typeKey == "CELULAR") {
            $typeKey = 'phoneNumber';
        } else if ($typeKey == "EMAIL") {
            $typeKey = 'email';
        } else if ($typeKey == "CHAVE ALEATÓRIA") {
            $typeKey = 'randomKey';
        }

        $userSaque = User::find($userId);

        $c_i = $userSaque->cpf;
        $s_i = $userSaque->chave_pix;

        $sandbox = true;

        $data = [
            'key' => $key,
            'typeKey' => $typeKey,
            'value' => $value,
            'callbackUrl' => 'https://webhook.site/e003db5a-7b95-483f-acbf-23aafdc15160',
        ];

        try {
            $response = $client->request('POST', urlSuitPay($sandbox) . '/api/v1/gateway/pix-payment', [
                'headers' => [
                    'accept' => 'application/json',
                    'ci' => $c_i,
                    'cs' => $s_i,
                    'content-type' => 'application/json',
                ],
                'json' => $data,
            ]);

            $credito = Credito::where('idprod', '=', $idprod)->first();
            $credito->valor = "-7";
            $credito->save();
            echo $response->getBody();

        } catch (ClientException $e) {
            $response = $e->getResponse();
            if ($response !== null) {
                $body = $response->getBody()->getContents();
                $json = json_decode($body, true);
                if (isset($json['response']) && $json['response'] === 'PIX_KEY_NOT_FOUND') {
                    // Se a chave PIX não for encontrada, faça algo com essa informação
                    echo $json['response'];
                } else {
                    // Caso contrário, manipule a resposta de outra forma
                    echo $json['response'];
                }
            } else {
                // Caso não haja uma resposta, trate o erro de outra forma
                echo 'Erro desconhecido: ' . $e->getMessage();
            }
        }
    }

    //webhook
    // public function webhookPix(Request $request)
    // {
    //     $data_now = date('Y-m-d H:i:s');

    //     $paymentStatus = $request->input('payment.status');

    //     $idprod = $request->input('payment.description');

    //     $valor = $request->input('payment.value');

    //     $valor = number_format($valor, '2');

    //     $valor = strval($valor);
    //     // Validação caso o pagamento estiver pendente.
    //     if (empty($idprod)) {
    //         $dados = $request->all();

    //         // Converte o array associativo em uma string JSON
    //         $jsonString = json_encode($dados, JSON_PRETTY_PRINT);

    //         // Especifica o caminho e o nome do arquivo
    //         $caminhoArquivo = storage_path('app/json/arquivo.json');

    //         // Salva a string JSON no arquivo
    //         file_put_contents($caminhoArquivo, $jsonString);

    //         return response()->json(['mensagem' => 'Arquivo JSON criado e salvo com sucesso.']);

    //     } else {
    //         if ($paymentStatus == "RECEIVED") {

    //             $creditos = Credito::where('idprod', '=', $idprod)->first();

    //             if (!$creditos) {
    //                 $creditos = new Credito;
    //                 $creditos->idprod = $idprod;
    //                 $creditos->data = $data_now;
    //                 $creditos->valor = $valor;
    //                 $creditos->status = '1';
    //                 $creditos->tipo = '1';
    //                 $creditos->save();

    //             } else {
    //                 $creditos->valor = $valor;
    //                 $creditos->status = '1';
    //                 $creditos->save();

    //             }


    //         } else {
    //             $dados = $request->all();

    //             // Converte o array associativo em uma string JSON
    //             $jsonString = json_encode($dados, JSON_PRETTY_PRINT);

    //             // Especifica o caminho e o nome do arquivo
    //             $caminhoArquivo = storage_path('app/json/arquivo.json');

    //             // Salva a string JSON no arquivo
    //             file_put_contents($caminhoArquivo, $jsonString);

    //             return response()->json(['mensagem' => 'Arquivo JSON criado e salvo com sucesso.']);
    //         }
    //     }


    // }


    public function webhookPix(Request $request)
    {
        $data_now = date('Y-m-d H:i:s');
        $paymentStatus = $request->input('payment.status');
        $idprod = $request->input('payment.description');
        $valor = $request->input('payment.value');

        $valor = number_format($valor, 2);
        $valor = strval($valor);

        // Se a descrição (idprod) for vazia
        if (empty($idprod)) {
            $dados = $request->all();
            $jsonString = json_encode($dados, JSON_PRETTY_PRINT);
            $caminhoArquivo = storage_path('app/json/arquivo.json');
            file_put_contents($caminhoArquivo, $jsonString);

            return response()->json(['mensagem' => 'Arquivo JSON criado e salvo com sucesso.']);
        }

        // Se tiver mais de 15 caracteres, ignora e retorna 200
        if (strlen($idprod) > 15) {
            // Só loga o que veio (para debug futuro)
            \Log::info('Webhook ignorado: description maior que 15 caracteres', [
                'description' => $idprod,
                'payload' => $request->all(),
            ]);
            return response()->json(['mensagem' => 'Webhook recebido, mas ignorado (description > 15).'], 200);
        }

        // Somente se for recebido e idprod válido
        if ($paymentStatus == "RECEIVED") {

            $creditos = Credito::where('idprod', '=', $idprod)->first();

            if (!$creditos) {
                $creditos = new Credito;
                $creditos->idprod = $idprod;
                $creditos->data = $data_now;
                $creditos->valor = $valor;
                $creditos->status = '1';
                $creditos->tipo = '1';
                $creditos->save();
            } else {
                $creditos->valor = $valor;
                $creditos->status = '1';
                $creditos->save();
            }

        } else {
            $dados = $request->all();
            $jsonString = json_encode($dados, JSON_PRETTY_PRINT);
            $caminhoArquivo = storage_path('app/json/arquivo.json');
            file_put_contents($caminhoArquivo, $jsonString);

            return response()->json(['mensagem' => 'Arquivo JSON criado e salvo com sucesso.']);
        }

        // Retorna sucesso genérico pro Asaas/PIX
        return response()->json(['mensagem' => 'Webhook processado com sucesso.'], 200);
    }
    
    public function webhookAsaas(Request $request)
    {
        $payload = $request->all();
        $type = $request->input('type');

        // Loga todo o payload recebido (útil para auditoria)
        \Log::info('Webhook ASAAS recebido', ['payload' => $payload]);

        // Se não tiver tipo, retorna 200 para evitar reentrega
        if (!$type) {
            return response()->json([
                'status' => 'IGNORED',
                'reason' => 'missing type'
            ], 200);
        }

        // ==== TRATAMENTO DE TRANSFER ====
        if ($type === 'TRANSFER') {

            // Validação mínima
            $data = $request->validate([
                'transfer' => 'required|array',
                'transfer.value' => 'required|numeric',
            ]);

            $value = (float) data_get($data, 'transfer.value', 0);

            if ($value <= 100) {
                // Aprova
                \Log::info('Transferência aprovada', ['value' => $value]);
                return response()->json([
                    'status' => 'APPROVED'
                ], 200);
            } else {
                // Recusa
                \Log::warning('Transferência recusada (valor alto)', ['value' => $value]);
                return response()->json([
                    'status' => 'REFUSED',
                    'refuseReason' => 'Transferência não encontrada no nosso banco'
                ], 200);
            }
        }

        // ==== TRATAMENTO DE PIX_REFUND ====
        if ($type === 'PIX_REFUND') {

            // Validação mínima
            $data = $request->validate([
                'pixRefund' => 'required|array',
                'pixRefund.id' => 'required|string',
                'pixRefund.value' => 'required|numeric',
                'pixRefund.status' => 'required|string',
            ]);

            $id = data_get($data, 'pixRefund.id');
            $value = (float) data_get($data, 'pixRefund.value');
            $status = data_get($data, 'pixRefund.status');
            $payment = data_get($data, 'pixRefund.payment');

            \Log::info('PIX_REFUND recebido', [
                'id' => $id,
                'value' => $value,
                'status' => $status,
                'payment' => $payment
            ]);

            // Apenas confirma recebimento (sem lógica de recusa/aprovação)
            return response()->json([
                'status' => 'ACK'
            ], 200);
        }

        // ==== SE NÃO FOR NENHUM DOS DOIS ====
        \Log::info('Webhook ignorado (tipo não tratado)', ['type' => $type]);
        return response()->json([
            'status' => 'IGNORED',
            'reason' => 'unsupported type'
        ], 200);
    }

    public function webhookPixSuitPay(Request $request)
    {
        $data_now = date('Y-m-d H:i:s');

        $paymentStatus = $request->input('statusTransaction');

        $idprod = $request->input('requestNumber');

        $valor = $request->input('value');

        $valor = number_format($valor, '2');

        $valor = strval($valor);
        // Validação caso o pagamento estiver pendente.
        if (empty($idprod)) {
            $dados = $request->all();

            // Converte o array associativo em uma string JSON
            $jsonString = json_encode($dados, JSON_PRETTY_PRINT);

            // Especifica o caminho e o nome do arquivo
            $caminhoArquivo = storage_path('app/json/arquivo.json');

            // Salva a string JSON no arquivo
            file_put_contents($caminhoArquivo, $jsonString);

            return response()->json(['mensagem' => 'Arquivo JSON criado e salvo com sucesso.']);

        } else {
            if ($paymentStatus == "PAID_OUT") {

                $creditos = Credito::where('idprod', '=', $idprod)->first();

                if (!$creditos) {
                    $creditos = new Credito;
                    $creditos->idprod = $idprod;
                    $creditos->data = $data_now;
                    $creditos->valor = $valor;
                    $creditos->status = '1';
                    $creditos->tipo = '1';
                    $creditos->save();

                } else {
                    $creditos->valor = $valor;
                    $creditos->status = '1';
                    $creditos->save();

                }


            } else {
                $dados = $request->all();

                // Converte o array associativo em uma string JSON
                $jsonString = json_encode($dados, JSON_PRETTY_PRINT);

                // Especifica o caminho e o nome do arquivo
                $caminhoArquivo = storage_path('app/json/arquivo.json');

                // Salva a string JSON no arquivo
                file_put_contents($caminhoArquivo, $jsonString);

                return response()->json(['mensagem' => 'Arquivo JSON criado e salvo com sucesso.']);
            }
        }


    }

    private function getCredenciais($userID)
    {
        $credenciais = [];

        $user = User::find($userID);
        if (isset($user)) {
            $credenciais = [
                'client_id' => $user->cpf,
                'secret_id' => $user->chave_pix
            ];
        }

        return $credenciais;
    }
    public function webhookSendPix(Request $request)
    {
        return response()->json('Teste webhookSendPix', 200);
    }
}
