<?php

namespace App\Http\Controllers\Api;
use Illuminate\Support\Facades\DB;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Tablet;
use App\Models\TabletConfig;
use App\Models\Ponto;
use App\Models\User;
use App\Models\Jogador;
use App\Models\Credito;
use App\Models\Transacao;
use App\Models\Metrica;
use App\Models\MetricaParcial;
use App\Models\Leitura;
use App\Models\CobrancaAgregado;
use App\Models\CobrancaLocacao;
use App\Models\CobrancaPonto;

class TabletController extends Controller
{
    public function atualizarTablet(Request $request)
    {
        $idprod = $request->input('idprod'); 
        $dispversion = $request->input('dispversion');
        $acum1med = $request->input('acum1');
        $acum2med = $request->input('acum2');
        $acum3med = $request->input('acum3'); 
        $acum4med = $request->input('acum4'); 
        $creditos = "SC";
        $servidor = "OFF";
        $lastversion = 0;
        $destrava = 0;
        $id_ponto = 0;
        $sorteado = "NA";
        $data_sorteio;
        $minutos = 0;
        $creditos = 0;


        date_default_timezone_set('America/Sao_Paulo');
        $agora = date ('Y-m-d H:i:s');

        $tablet = Tablet::where('idprod', '=', $idprod)->where('ligado', '=', '1')->first();
        $tablet->ultimo_contato = $agora;
        $tablet->save();

       

        if($tablet === null){
            $servidor = "OFF";
        }else{
            $servidor = "ON";
            $lastversion = $tablet->lastversion;
            $destrava = $tablet->destrava;
            $id_ponto = $tablet->id_ponto;
            $creditos = $tablet->creditos;

            $jogador = Jogador::where('idprod', '=', $idprod)->first();

            if($jogador === null){
                $servidor = "OFF";
                $tablet->ligado = 0;
                $tablet->save();
            }
        }

        if($lastversion == $dispversion){
            $tablet->acum1med = $acum1med;
            $tablet->acum2med = $acum2med;
            $tablet->acum3med = $acum3med;
            $tablet->acum4med = $acum4med;
            $tablet->save();

        }

        $credito = Credito::where('idprod', '=', $idprod)->first();
        if($credito == null || $credito->status == 0){
            $creditos = "SC";
        }else {
            $creditos = $credito->valor;
            $credito->status = 0;
            $credito->save();
        }

        echo $creditos."#"
            .$servidor."#"
            .$lastversion."#"
			.$destrava."#"
			.$idprod."#Brazil#";

    }

    public function atualizarTablets(Request $request)
    {
        $idprod = $request->input('idprod'); 
        $dispversion = $request->input('dispversion');
        $acum1med = $request->input('acum1');
        $acum2med = $request->input('acum2');
        $acum3med = $request->input('acum3'); 
        $acum4med = $request->input('acum4'); 
        $creditos = "SC";
        $servidor = "OFF";
        $lastversion = 0;
        $destrava = 0;
        
        date_default_timezone_set('America/Sao_Paulo');
        $agora = date ('Y-m-d H:i:s');
        
        $tablet = Tablet::where('idprod', '=', $idprod)->first();
        $tablet->ultimo_contato = $agora;
        $tablet->save();

        $tablet = Tablet::where('idprod', '=', $idprod)->where('ligado', '=', '1')->first();

        if($tablet === null){
            $servidor = "OFF";
        }else{
            $servidor = "ON";
            $lastversion = $tablet->lastversion;
            $destrava = $tablet->destrava;
        }

        if ($lastversion == $dispversion)
        {
            $tablet->acum1med = $acum1med;
            $tablet->acum2med = $acum2med;
            $tablet->acum3med = $acum3med;
            $tablet->acum4med = $acum4med;
            $tablet->save();

        }

        $credito = Credito::where('idprod', '=', $idprod)->orderBy('data', 'desc')->first();

        if($credito == null || $credito->status == 0){
            $creditos = "SC";
        }else{
            $creditos = $credito->valor;
            $credito->status = 0;
            $credito->save();
        }       

        echo $creditos."#"
            .$servidor."#"
            .$lastversion."#"
            .$destrava."#";

    }

    public function autenticar(Request $request)
    {
      //
    }

    public function tablet(Request $request)
    {
       $tablet = Tablet::where('idprod', '=', $request->input('idprod'))->first();
        
       if(!$tablet){
        echo "NA#";
       }else{
        $resultString = implode("#", [
            $tablet->lastversion,
            $tablet->dificuldade,
            $tablet->matematica_slot,
            $tablet->acum1min,
            $tablet->acum1med,
            $tablet->acum1max,
            $tablet->acum2min,
            $tablet->acum2med,
            $tablet->acum2max,
            $tablet->acum3min,
            $tablet->acum3med,
            $tablet->acum3max,
            $tablet->porcent_acumu,
            $tablet->destrava,
            $tablet->acum4min,
            $tablet->acum4med,
            $tablet->acum4max,
            $tablet->acum5min,
            $tablet->acum5med,
            $tablet->acum5max,
            $tablet->acum6min,
            $tablet->acum6med,
            $tablet->acum6max,
            $tablet->creditoteclado,
            $tablet->centavosbingo,
            $tablet->apostamaxhalloween,
            $tablet->leituraonlinesincronizada,
            $tablet->zerarleituraparcial,
            $tablet->zerarleituraoficialbackup,
            $tablet->zerarleituravirtual,
            $tablet->matematica_slot,
            $tablet->modo_slot,
            $tablet->retencao_slots,
            $tablet->dificul_bonus,
            $tablet->taxa_maxima,
            $tablet->acrecimo_taxa_max,
            $tablet->periodo_reducao,
            $tablet->extras_min_rotina,
            $tablet->saldo_para_acumulao,
            $tablet->premio_do_acumulado,
            $tablet->tam_premio_max,
            $tablet->saldo_min_bingo_g1,
            $tablet->saldo_min_bingo_g2,
            $tablet->saldo_min_bingo_g3,
            $tablet->qtn_jogos_azar,
            $tablet->probabilidada_premios_azar,
            $tablet->taxa_max_chance_azar,
            $tablet->qtn_jogos_normal,
            $tablet->probabilidada_premios_normal,
            $tablet->taxa_max_chance_normal,
            $tablet->qtn_jogos_neutro,
            $tablet->probabilidade_premios_neutro,
            $tablet->taxa_max_chance_neutro,
            $tablet->qtn_jogos_sorte,
            $tablet->probabilidade_premios_sorte,
            $tablet->taxa_max_chance_sorte,
            $tablet->qtn_jogos_moderado,
            $tablet->probabilidade_premios_moderado,
            $tablet->taxa_max_chance_moderado,
            $tablet->limites_nivel_show_n2,
            $tablet->limites_nivel_show_n3,
            $tablet->limites_nivel_show_n4,
            $tablet->status_bonus,
            $tablet->valor,
            $tablet->kiosk_sis,
            $tablet->tipo_tela,
            $tablet->acumSenaMin,
            $tablet->acumSenaAtu,
            $tablet->acumSenaMax,
            $tablet->acumBombaMin,
            $tablet->acumBombaAtu,
            $tablet->acumBombaMax,
            $tablet->tipo_inter,
            $tablet->senha,
        ]);
        echo $resultString;
       }
      
    }

    public function verificaStatus(Request $request){
        // Fetch the version from the tablet_config table
        
       $versaoRow = TabletConfig::select('versao')->first();

        $result = Tablet::join('users', 'tablet.cliente', '=', 'users.username')
            ->where('tablet.ligado', 1)
            ->where('tablet.idprod',  $request->input('idprod'))
            ->where('users.status', 1)
            ->where('tablet.cliente', $request->input('dono'))
            ->select('tablet.ligado')
            ->get();

        if ($result->isEmpty()) {
            echo "OFF#";
        } else {
            echo "ON#". $versaoRow->versao;
            // Se você quiser acessar a coluna 'ligado' do primeiro resultado, pode fazer assim:
            
        }
    }

    public function cadastrar(Request $request){
        $tablet = Tablet::select('idprod', 'cliente')
        ->where('idprod', $request->input('idprod'))
        ->get();

        if($tablet->count() == 0){
            $ponto = Ponto::where('nome', '=', $request->input('ponto'))->first();
            $user = User::where('cpf', '=', $request->input('dono'))->first();

             echo($user->id);
            // echo($ponto->id);
            return;
            $data_now = date("Y-m-d H:i:s");

            $tablet = new Tablet();
            $tablet->idprod = $request->input('idprod');
            $tablet->cliente = $request->input('dono');
            $tablet->cadastro = $data_now;
            $tablet->validade = 0;
            $tablet->status = 0;
            $tablet->ligado = 1;
            $tablet->zerar = 0;
            $tablet->destrava = 0;
            $tablet->expiracao = 0;
            $tablet->id_ponto = $ponto->id;
            $tablet->id_apoio = $ponto->id_apoio;
            $tablet->dificuldade = 80;
            $tablet->pendrive_id = 1;
            $tablet->antecipado = 0;
            $tablet->creditoteclado = 0;
            $tablet->centavosbingo = 10;
            $tablet->apostamaxhalloween = 10;
            $tablet->leituraonlinesincronizada = 1;
            $tablet->zerarleituraparcial = 0;
            $tablet->zerarleituraoficialbackup = 0;
            $tablet->acum1min = 200.00;
            $tablet->acum2min = 300.00;
            $tablet->acum3min = 400.00;
            $tablet->acum1med = 200.00;
            $tablet->acum2med = 300.00;
            $tablet->acum3med = 400.00;
            $tablet->acum1max = 500.00;
            $tablet->acum2max = 600.00;
            $tablet->acum3max = 700.00;
            $tablet->acum4min = 100.00;
            $tablet->acum4med = 100.00;
            $tablet->acum4max = 200.00;
            $tablet->acum5min = 100.00;
            $tablet->acum5med = 100.00;
            $tablet->acum5max = 100.00;
            $tablet->acum6min = 100.00;
            $tablet->acum6med = 100.00;
            $tablet->acum6max = 100.00;
            $tablet->acum6max = 100.00;
            $tablet->acumSenaMin = 20.00;
            $tablet->acumSenaAtu = 50.00;
            $tablet->acumSenaMax = 100.00;
            $tablet->acumBombaMin = 20.00;
            $tablet->acumBombaAtu = 40.00;
            $tablet->acumBombaMax = 60.00;
            $tablet->porcent_acumu = 3;
            $tablet->lastversion = 1;
            $tablet->ativo = 1;
            $tablet->zerarleituravirtual = 0;
            $tablet->matematica_slot = 1;
            $tablet->modo_slot = 3;
            $tablet->ultimo_contato = $data_now;
            $tablet->retencao_slots = 1;
            $tablet->dificul_bonus = 20000;
            $tablet->taxa_maxima = 0.55;
            $tablet->acrecimo_taxa_max = 0.03;
            $tablet->periodo_reducao = 10000;
            $tablet->extras_min_rotina = 50;
            $tablet->saldo_para_acumulao = 100000;
            $tablet->premio_do_acumulado = 200;
            $tablet->tam_premio_max = 3;
            $tablet->saldo_min_bingo_g1 = 35000;
            $tablet->saldo_min_bingo_g2 = 50000;
            $tablet->saldo_min_bingo_g3 = 100000;
            $tablet->qtn_jogos_azar = 8;
            $tablet->probabilidada_premios_azar = 0.25;
            $tablet->taxa_max_chance_azar = 0;
            $tablet->qtn_jogos_normal = 4;
            $tablet->probabilidada_premios_normal = 0.5;
            $tablet->taxa_max_chance_normal = 0.03;
            $tablet->qtn_jogos_neutro = 3;
            $tablet->probabilidade_premios_neutro = 0.25;
            $tablet->taxa_max_chance_neutro = 0;
            $tablet->qtn_jogos_sorte = 5;
            $tablet->probabilidade_premios_sorte = 0.55;
            $tablet->taxa_max_chance_sorte = 0.04;
            $tablet->qtn_jogos_moderado = 8;
            $tablet->probabilidade_premios_moderado = 0.55;
            $tablet->taxa_max_chance_moderado = 0.01;
            $tablet->limites_nivel_show_n2 = 0.4;
            $tablet->limites_nivel_show_n3 = 0.2;
            $tablet->limites_nivel_show_n4 = 0.2;
            $tablet->valor = 0;
            $tablet->status_bonus = 0;
            $tablet->kiosk_sis = 0;
            $tablet->tipo_tela = 1;
            $tablet->tipo_inter = 0;
            $tablet->senha = 8520;

            $tablet->save();
        }else{

        }

        
    }

    public function sendLeituraRealtime(Request $request){
        $data_now = date('Y-m-d H:i:s');
        $idprod = $request->input('idprod');
        $entrada = $request->input('entrada') / 100;
        $saida = $request->input('saida') / 100;
        $entradaVirtual = $request->input('entrada_virtual') / 100;
        $saidaVirtual = $request->input('saida_virtual') / 100;

        $data = $request->input('data') ;
        $status = $request->input('status');
        $dataorder = $request->input('dataorder');

        $fl_expirado = false;
        $fl_revalidar = false;
        $vlidade = 0;
        $acao = 0;


        try {

       
            
        } catch (Exception $e) {
            print_r($e->getMessage());
        }

        

        $leitura = Leitura::where('idprod', '=', $idprod)->first();

        if ($entradaVirtual == 0 && $saidaVirtual == 0) {
            $tablet = Tablet::where('idprod', $idprod)->first();
            if($tablet){
                $tablet->zerarleituravirtual = 0;
                $tablet->save();
            }
        }

        $metrica = Metrica::where('idprod', $idprod)
        ->orderBy('dataorder', 'desc')
        ->first();
        


        if($metrica){
            $idMetrica = $metrica->id;
            if(!$leitura){
                $leitura = new Leitura;
                $leitura->id_metrica = $idMetrica;
                $leitura->idprod = $idprod;
                $leitura->entrada = $entrada;
                $leitura->saida = $saida;
                $leitura->entrada_virtual = $entradaVirtual;
                $leitura->saida_virtual = $saidaVirtual;
                $leitura->data = $data;
                $leitura->status = $status;
                $leitura->dataorder = $data_now;
                $leitura->save();
                echo "OK---splithere---";
            }else {
                $leitura = Leitura::where('idprod', '=', $idprod)->first();
                $leitura->entrada = $entrada;
                $leitura->saida = $saida;
                $leitura->entrada_virtual = $entradaVirtual;
                $leitura->saida_virtual = $saidaVirtual;
                $leitura->data = $data;
                $leitura->status = $status;
                $leitura->save();
                echo "OK---splithere---";
            }
        }
    }

    public function sendleiturarealtime_dbsync(Request $request)
    {
        $idprod = $request->input('idprod');

        $creditos = $request->input('creditos');
        $apostado = $request->input('apostado');
        $premiado = $request->input('premiado');
        
        $leitura = Leitura::where('idprod', '=', $idprod)->first();
        
        if($leitura){
            $leitura->creditos = $creditos;
            $leitura->apostado = $creditos;
            $leitura->premiado = $creditos;
            $leitura->save();
        }
       
    }

    public function insertCredits(Request $request)
    {
        //dd($request->all());
        $idprod = $request->input('idprod');
        $valor = $request->input('valor');
        $data_now = date('Y-m-d H:i:s');

        $credito = Credito::where('idprod', '=', $idprod)->first();

        if(!$credito){
            $credito = new Credito;
            $credito->idprod = $idprod;
            $credito->data =  $data_now;
            $credito->valor = $valor;
            $credito->status = 1;
            $credito->tipo = 1;
            $credito->save();
        }else {
            $credito->valor = $valor;
            $credito->status = 1;
            $credito->save();
        }
    }

    
}
