<?php

namespace App\Http\Controllers;

use App\Models\Tablet;
use App\Models\User;
use App\Models\Cliente;
use App\Models\Ponto;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Hash;
use Session;

class LoginController extends Controller
{
   public function login(Request $request)
   {
      return view('site.login');
   }

    public function autorizar(Request $request)
    {


        $credentials = [
            'email' => $request->email,
            'password' => $request->password,
        ];
        
        if (Auth::guard('cliente')->attempt($credentials, true)) {
            // O usuário foi autenticado com sucesso
            return response()->json(['nivel' => Auth::guard('cliente')->user()->nivel]);
        } else {
            // A autenticação falhou
            return response()->json(['msg' => 'Usuário ou senha inválidos!'], 403);
        }


    }

    public function logout()
    {
        Auth::guard('cliente')->logout();
        return redirect('/login');
    }

 
}
