<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use \App\Models\User;
use \App\Models\Cliente;
use \App\Models\Ponto;
use \App\Models\Tablet;
use \App\Models\Leitura;

use Hash;
use Session;

use Efi\Exception\EfiException;
use Efi\EfiPay;

class PrincipalController extends Controller
{
    public function __construct() {
        view()->share(['tituloPagina'=>'Home']);
        view()->share(['subTitulo'=>'Home']);
    }

    public function home() {
        return view('site.index');
    }

    public function cadastrar($token) {
      
        return view('site.cad-form');
    }

    public function salvar1(Request $request)
    {
        dd($request->token);

        $rules = [  
            'email'=>'required|unique:user',   
            'cpf'=>'required|unique:user',   
        ];
        //############ Retorna as menssagem de cada campo não preenchido ################
        $messages = [
            'email.unique'=>'O email informado já existe.',
            'cpf.unique'=>'O Cpf informado já existe.',
        ];
        //############ Verifica a validação dos campos #################
        $this->validate($request, $rules, $messages);

        $data_now = date('Y-m-d H:i:s');
        

        if ($request->filled('token')) {
            // O campo 'token' está presente e não está vazio
            $token = $request->input('token');
            // Faça algo com $token
        } else {
            // O campo 'token' não está presente na requisição ou está vazio
        }

        $user = new User;
        $user->name = '';
        $user->nome = $request->input('nome');
        $user->last_name = '';
        $user->email = $request->input('email');
        $user->passwd = Hash::make($request->input('password'));
        $user->username = $request->input('cpf');
        $user->password = $request->input('password');
        $user->nivel = '3';
        $user->cadastro = $data_now;
        $user->id_apoio = '1';
        $user->porcentagem = '0';
        $user->id_pais = '33';
        $user->data_corte = ''.$data_now;
        $user->validade = '0';
        $user->revalidar = '0';
        $user->data_validacao = $data_now;
        $user->status = '1';
        $user->status = '1';
        $user->afiliado = '0';
        $user->fechar_faturas_ponto = '0';
        $user->cpf = $request->input('cpf');
        $user->chave_pix = $request->input('chavePix');
        // $user->saldo = '0';
        
        if($user->save()) {
            $ponto = new Ponto;
            $ponto->nome = $user->nome;
            $ponto->porcent_ponto = '0';
            $ponto->cadastro  = $data_now;
            $ponto->id_apoio = $user->id;
            $ponto->status = '1';
            $ponto->passwd = $user->passwd;
            $ponto->modo = '0';

            if($ponto->save()){
               
                $tablet = Tablet::select('idprod', 'cliente')
                ->where('idprod', $user->cpf)
                ->get();

                if($tablet->count() == 0){

                    $data_now = date("Y-m-d H:i:s");

                    $tablet = new Tablet();
                    $tablet->idprod = $user->cpf;
                    $tablet->cliente = $ponto->nome;
                    $tablet->cadastro = $data_now;
                    $tablet->validade = 0;
                    $tablet->status = 0;
                    $tablet->ligado = 1;
                    $tablet->zerar = 0;
                    $tablet->destrava = 0;
                    $tablet->expiracao = 0;
                    $tablet->id_ponto = $ponto->id;
                    $tablet->id_apoio = $user->id;
                    $tablet->dificuldade = 80;
                    $tablet->pendrive_id = 1;
                    $tablet->antecipado = 0;
                    $tablet->creditoteclado = 0;
                    $tablet->centavosbingo = 10;
                    $tablet->apostamaxhalloween = 10;
                    $tablet->leituraonlinesincronizada = 1;
                    $tablet->zerarleituraparcial = 0;
                    $tablet->zerarleituraoficialbackup = 0;
                    $tablet->acum1min = 200.00;
                    $tablet->acum2min = 300.00;
                    $tablet->acum3min = 400.00;
                    $tablet->acum1med = 200.00;
                    $tablet->acum2med = 300.00;
                    $tablet->acum3med = 400.00;
                    $tablet->acum1max = 500.00;
                    $tablet->acum2max = 600.00;
                    $tablet->acum3max = 700.00;
                    $tablet->acum4min = 100.00;
                    $tablet->acum4med = 100.00;
                    $tablet->acum4max = 200.00;
                    $tablet->acum5min = 100.00;
                    $tablet->acum5med = 100.00;
                    $tablet->acum5max = 100.00;
                    $tablet->acum6min = 100.00;
                    $tablet->acum6med = 100.00;
                    $tablet->acum6max = 100.00;
                    $tablet->acum6max = 100.00;
                    $tablet->acumSenaMin = 20.00;
                    $tablet->acumSenaAtu = 50.00;
                    $tablet->acumSenaMax = 100.00;
                    $tablet->acumBombaMin = 20.00;
                    $tablet->acumBombaAtu = 40.00;
                    $tablet->acumBombaMax = 60.00;
                    $tablet->porcent_acumu = 3;
                    $tablet->lastversion = 1;
                    $tablet->ativo = 1;
                    $tablet->zerarleituravirtual = 0;
                    $tablet->matematica_slot = 1;
                    $tablet->modo_slot = 3;
                    $tablet->ultimo_contato = $data_now;
                    $tablet->retencao_slots = 1;
                    $tablet->dificul_bonus = 20000;
                    $tablet->taxa_maxima = 0.55;
                    $tablet->acrecimo_taxa_max = 0.03;
                    $tablet->periodo_reducao = 10000;
                    $tablet->extras_min_rotina = 50;
                    $tablet->saldo_para_acumulao = 100000;
                    $tablet->premio_do_acumulado = 200;
                    $tablet->tam_premio_max = 3;
                    $tablet->saldo_min_bingo_g1 = 35000;
                    $tablet->saldo_min_bingo_g2 = 50000;
                    $tablet->saldo_min_bingo_g3 = 100000;
                    $tablet->qtn_jogos_azar = 8;
                    $tablet->probabilidada_premios_azar = 0.25;
                    $tablet->taxa_max_chance_azar = 0;
                    $tablet->qtn_jogos_normal = 4;
                    $tablet->probabilidada_premios_normal = 0.5;
                    $tablet->taxa_max_chance_normal = 0.03;
                    $tablet->qtn_jogos_neutro = 3;
                    $tablet->probabilidade_premios_neutro = 0.25;
                    $tablet->taxa_max_chance_neutro = 0;
                    $tablet->qtn_jogos_sorte = 5;
                    $tablet->probabilidade_premios_sorte = 0.55;
                    $tablet->taxa_max_chance_sorte = 0.04;
                    $tablet->qtn_jogos_moderado = 8;
                    $tablet->probabilidade_premios_moderado = 0.55;
                    $tablet->taxa_max_chance_moderado = 0.01;
                    $tablet->limites_nivel_show_n2 = 0.4;
                    $tablet->limites_nivel_show_n3 = 0.2;
                    $tablet->limites_nivel_show_n4 = 0.2;
                    $tablet->valor = 0;
                    $tablet->status_bonus = 0;
                    $tablet->kiosk_sis = 0;
                    $tablet->tipo_tela = 1;
                    $tablet->tipo_inter = 0;
                    $tablet->senha = 8520;

                    if( $tablet->save() ) {
                       
                        $leitura = new Leitura;
                        $leitura->id_metrica = '0';
                        $leitura->idprod = $user->cpf;
                        $leitura->creditos = '0,00';
                        $leitura->entrada = '0';
                        $leitura->saida = '0';
                        $leitura->entrada_virtual = '0';
                        $leitura->saida_virtual = '0';
                        $leitura->apostado = '0';
                        $leitura->premiado = '0';
                        $leitura->status = '0';
                        $leitura->data = '';
                        $leitura->dataorder = $data_now;
                        $leitura->ativo = '1';
                        if( $leitura->save() ) {
                            echo "Cadastro efetuado com sucesso!";
                        }
                    }
                }else{

                }
            }else {
                $user = User::find($user->id);
                $user->delete();
                echo "Erro ao cadastrar o usuário!";
            }

        }else{
            echo "Erro ao cadastrar o usuário!";
        }
    }

    public function salvar(Request $request)
    {
        // dd($request->all());
        $rules = [  
            'email'=>'required|unique:cliente',   
            'cpf'=>'required|unique:cliente',   
        ];
        //############ Retorna as menssagem de cada campo não preenchido ################
        $messages = [
            'email.unique'=>'O email informado já existe.',
            'cpf.unique'=>'O Cpf informado já existe.',
        ];
        //############ Verifica a validação dos campos #################
        $this->validate($request, $rules, $messages);

        $data_now = date('Y-m-d H:i:s');
        
        $cliente = new Cliente;
        
        $filialEncontrado = false;

        $user = User::find($request->token);

        if($user){
            $filialEncontrado = true;
        }

        if ($request->filled('token') && $filialEncontrado) {
            $cliente->name = $request->nome;
            $cliente->last_name = '';
            $cliente->cpf = $request->cpf;
            $cliente->tipo_pix = $request->tipoPix;
            $cliente->chave_pix = $request->chavePix;
            $cliente->email = $request->email;
            $cliente->password =  Hash::make($request->password);
            $cliente->user_id = $request->token;
            
            if($cliente->save()) {
                echo "Cadastro efetuado com sucesso!";
            }
          
        } else {
            $cliente->name = $request->nome;
            $cliente->last_name = '';
            $cliente->cpf = $request->cpf;
            $cliente->tipo_pix = $request->tipoPix;
            $cliente->chave_pix = $request->chavePix;
            $cliente->email = $request->email;
            $cliente->password = Hash::make($request->password);
            $cliente->user_id = 41;
            
            if($cliente->save()) {
                echo "Cadastro efetuado com sucesso!";
            }
        }

        
    }

    public function formCad(Request $request) 
    {       
        return view('site.form-cad');
    }

    public function update(Request $request)
    {
        $cliente = Cliente::find($request->id);
        $cliente->name = $request->name;
        $cliente->cpf = $request->cpfcnpj;
        if($cliente->save()){
            return response()->json(['response' => 'Cadastro alterado com sucesso!'], 200);
        }
        
    }

    public function formCliente()
    {
        return view('site.clientes');
    }

    public function listarCliente(Request $request)
    {
       
        $id = $request->id;
        if( $id ){
            $clientes = Cliente::find($id);
        }else {
            $clientes = Cliente::all();
        }

        if( $clientes ) { 
            return response()->json(['parceiros' => $clientes], 200);
        }else{
            dd("Cliente não encontrado");
        }
    }
}
