<?php

namespace App\Models;

use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;
use Laravel\Sanctum\HasApiTokens;

use App\Models\User;
use \App\Models\Tablet;
use \App\Models\Leitura;

class Cliente extends Authenticatable
{
    use Notifiable;
    use HasFactory;
    
    protected $fillable = [
        'name',
        'email',
        'password',
    ];
    
    protected $table = "cliente";
    
    protected $hidden = [
        'password',
        'remember_token',
    ];

   
    public function usuario()
    {
        return $this->belongsTo(User::class, 'user_id', 'id');
    }

    public function tablet()
    {
        return $this->belongsTo(Tablet::class, 'cpf', 'cliente');
    }

    public function leitura()
    {
        return $this->belongsTo(Leitura::class, 'cpf', 'idprod');
    }
}
