<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Tablet extends Model
{
    use HasFactory;
    protected $table = 'tablet';
    protected $fillable = [
        'idprod',
        'cliente',
        // Adicione outros campos aqui conforme necessário
    ];

    public $timestamps = false; // Desativa o preenchimento automático de created_at e updated_at


    public function user()
    {
        return $this->belongsTo(User::class, 'id_apoio');
    }

    public function leitura()
    {
        return $this->belongsTo(Leitura::class, 'idprod', 'idprod');
    }
}

