<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

class CreateUsersTable extends Migration
{
    /**
     * Run the migrations.
     *
     * @return void
     */
    public function up()
    {
        Schema::create('user', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('nome');
            $table->string('last_name');
            $table->string('email')->unique();
            $table->string('passwd');
            $table->string('username')->unique();
            $table->timestamp('email_verified_at')->nullable();
            $table->string('password');
            $table->unsignedTinyInteger('nivel')->default(3);
            $table->string('telefone', 30)->nullable();
            $table->dateTime('cadastro');
            $table->foreignId('id_apoio');
            $table->unsignedSmallInteger('porcentagem')->default(0);
            $table->unsignedSmallInteger('id_pais');
            $table->timestamp('data_corte')->default('2000-01-01 00:00:00');
            $table->unsignedInteger('validade')->default(0);
            $table->unsignedTinyInteger('revalidar')->default(0);
            $table->date('data_validacao')->nullable();
            $table->unsignedTinyInteger('status')->default(1);
            $table->unsignedTinyInteger('afiliado')->default(0)->comment('0 - Não, 1 - Sim');
            $table->unsignedTinyInteger('fechar_faturas_ponto')->default(0)->comment('Este campo será utilizado para saber se o operador poderá fechar faturas do ponto a que está cadastrado, 1=sim-0=não');
            $table->string('cpf', 15);
            $table->string('chave_pix', 255);
            $table->rememberToken();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     *
     * @return void
     */
    public function down()
    {
        Schema::dropIfExists('user');
    }
}
