<?php
$filename = 'c_leitura.php';

if (!file_exists($filename)) {
    header("Location: error.php");
    exit;
}
include 'c_leitura.php';

session_start();

$nivel_necessario = 6;

// Verifica se não há a variável da sessão que identifica o usuário
if (!isset($_SESSION['UsuarioID']) OR ( $_SESSION['UsuarioNivel'] > $nivel_necessario)) {
    // Destrói a sessão por segurança
    session_destroy();
    // Redireciona o visitante de volta pro login
    header("Location: index.php");
    exit;
}

require_once __DIR__ . DIRECTORY_SEPARATOR . "sealed" . DIRECTORY_SEPARATOR . "autoload.php";

require_once("db.php");

$argsGet = array(
    'id' => array(
        'filter' => FILTER_SANITIZE_STRING
    ),
    'cliente_fechamento' => array(
        'filter' => FILTER_SANITIZE_STRING
    ),
    'cliente' => array(
        'filter' => FILTER_SANITIZE_STRING
    ),
    'status' => array(
        'filter' => FILTER_SANITIZE_STRING
    )
);
$inputGET = filter_input_array(INPUT_GET, $argsGet);


if (!empty($inputGET['id'])) {

    $lote_fechamento = $inputGET['id'];
    $cliente_fechamento = $inputGET['cliente_fechamento'];
    if ($lote_fechamento) {
        if (empty($cliente_fechamento)) {
            $cliente_fechamento = '  AND lote_fechamento=' . $lote_fechamento;
        } else {
            $cliente_fechamento = ' AND c.cliente_fechamento = ' . $cliente_fechamento . ' AND lote_fechamento=' . $lote_fechamento;
        }
    } elseif (empty($cliente_fechamento)) {
        $cliente_fechamento = ' AND c.cliente_fechamento is null';
    }
    $cliente_fechamento.= '';// AND saldo_total >  0 ';
    $nome = utf8_decode(urldecode($inputGET['cliente']));
    $status = $inputGET['status'];

    switch ($_SESSION['UsuarioNivel']) {


        case '1':
            // Consulta Metrica
            $resultMetrica = mysql_query("SELECT t.id_apoio,c.idprod, c.id, acerto, saldo_total, comissao_locacao,comissao_ponto, comissao_dono,dataorder,entrada,saida,entrada_anterior,saida_anterior
									FROM metricas c
									INNER JOIN tablet t ON t.idprod = c.idprod
									INNER JOIN ponto p ON p.id = t.id_ponto
									WHERE c.status_leitura = '$status'
									AND p.nome LIKE '%$nome%'
                                                                        $cliente_fechamento
									ORDER BY c.id DESC");

            break;
        case '3':

            // Consulta Metrica
            $apoios = FUNCOES::getApoios($_SESSION[UsuarioID]);
            $resultMetrica = mysql_query("SELECT t.id_apoio,c.idprod, c.id, acerto, saldo_total, comissao_locacao,comissao_ponto, comissao_dono,dataorder,entrada,saida,entrada_anterior,saida_anterior
									FROM metricas c
									INNER JOIN tablet t ON t.idprod = c.idprod
									INNER JOIN ponto p ON p.id = t.id_ponto
									WHERE c.status_leitura = '$status'
									AND p.id_apoio IN ( " . implode(',', $apoios) . " )
									AND p.nome LIKE '%$nome%'
                                                                        $cliente_fechamento
									ORDER BY c.id DESC"); //c.lote_fechamento = '$idCobranca'

            break;
        case '4':

            $queryu = "SELECT porcentagem FROM user WHERE id =  " . $_SESSION['UsuarioID'];
            $result = mysql_query($queryu);
            $rowUSocio = mysql_fetch_array($result);

            //se deseja ver apenas leitura parcial

            if ($rowUSocio['porcentagem'] <> 0) {
                $colunm_locacao = "  IFNULL(round((select porcentagem from user where id = " . $_SESSION['UsuarioID'] . ") /100 * c.acerto),0) comissao_locacao";
            } else {
                $colunm_locacao = " IFNULL(comissao_locacao,0) AS comissao_locacao";
            }

            // Consulta Metrica
            $resultMetrica = mysql_query("SELECT t.id_apoio,c.idprod, c.id, acerto, saldo_total, $colunm_locacao,comissao_ponto, comissao_dono,dataorder,entrada,saida,entrada_anterior,saida_anterior
									FROM metricas c
									INNER JOIN tablet t ON t.idprod = c.idprod
									INNER JOIN ponto p ON p.id = t.id_ponto
									WHERE c.status_leitura = '$status'
									AND p.id_apoio IN ( " . $_SESSION[UsuarioID] . " )
									AND p.nome LIKE '%$nome%'
                                                                        $cliente_fechamento
									ORDER BY c.id DESC");

            break;
        case '6':


            $resultMetrica = mysql_query("SELECT t.id_apoio,c.idprod, c.id, acerto, saldo_total, comissao_locacao,comissao_ponto, comissao_dono,dataorder,entrada,saida,entrada_anterior,saida_anterior
									FROM metricas c
									INNER JOIN tablet t ON t.idprod = c.idprod
									INNER JOIN ponto p ON p.id = t.id_ponto
									INNER JOIN user u ON u.id_apoio = p.id
									WHERE c.status_leitura = '$status'
									AND p.nome LIKE '%$nome%'
									AND u.id = '$_SESSION[UsuarioID]'
                                                                        $cliente_fechamento
									ORDER BY c.id DESC");

            break;
        default:

            echo "ERRO AO CONSULTAR - PERFIL DE ACESSO $_SESSION[UsuarioNivel] DESCONHECIDO";
            exit;

            break;
    }
    // Consulta Metrica
    ?>
    <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">&times;</button>
        <h4 class="modal-title" id="myModalLabel">Detalhes da Leitura</h4>
    </div>
    <div class="modal-body">
        <div class="row">
            <div class="col-lg-12">
                <div class="table-responsive">
                    <table class="table table-striped table-bordered table-hover" id="dataTables-example">
                        <thead>
                            <tr>
                                <th class="hidden-xs">Descrição do acerto</th>
                                <th class="hidden-xs">Saldo</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php
                            $totalsaldo = 0;
                            $totalcomissaosocio = 0;
                            while ($rowMetrica = mysql_fetch_array($resultMetrica)) {

                                $totalponto += $rowMetrica['comissao_ponto'];

                                //se NÂO é operador
                                if ($_SESSION['UsuarioNivel'] != 6) {

                                    $totalsaldo += $total_saldo = $rowMetrica['saldo_total'];

                                    $queryu = "SELECT porcentagem FROM user WHERE id =  " . $rowMetrica['id_apoio']
                                            . " AND porcentagem <> 0";
                                    $result = mysql_query($queryu);
                                    $rowU = mysql_fetch_array($result);
                                    if ($_SESSION['UsuarioNivel'] == 3 && $rowU['porcentagem']) {

                                        /**
                                         * CLIENTE
                                         */
                                        $queryuser = "SELECT nivel,porcentagem FROM user "
                                                . " WHERE id =  " . $rowMetrica['id_apoio']
                                                . " AND nivel = 4";
                                        $resultuser3 = mysql_query($queryuser);
                                        $rowUser3 = mysql_fetch_array($resultuser3);
                                        if ($rowUser3['porcentagem']) {
                                            $comissoes = $rowMetrica['comissao_dono'] + $rowMetrica['comissao_ponto'] + $rowMetrica['comissao_locacao'];
                                            $totalcomissaosocio += $rowMetrica['acerto'] - $comissoes;
                                        }

                                        //$totalcomissaosocio = ($rowMetrica['saldo_total']) - ($rowMetrica['comissao_dono'] + $rowMetrica['comissao_ponto'] + $rowMetrica['comissao_locacao']);
                                        $totallocacao += $rowMetrica['comissao_locacao'];
                                        $totaldono += $rowMetrica['comissao_dono'];
                                    } elseif ($_SESSION['UsuarioNivel'] == 4 && $rowUSocio['porcentagem'] <> 0) {
                                        $totallocacao += $rowMetrica['comissao_locacao'];
                                        /**
                                         * SÓCIO
                                         */
                                        $totaldono += $totallocacao - $totalponto;
                                    } elseif ($_SESSION['UsuarioNivel'] == 1) {
                                        /**
                                         * ADMIN
                                         */
                                        $totalcomissaosocio = 0;
                                        $queryuser = "SELECT nivel,porcentagem FROM user "
                                                . " WHERE id =  " . $rowMetrica['id_apoio'];
                                        $resultuser3 = mysql_query($queryuser);
                                        $rowUser3 = mysql_fetch_array($resultuser3);
                                        if ($rowUser3['porcentagem']) {
                                            if ($rowUser3['nivel'] == 4) { //caso comissao_sócio
                                                $comissoes = $rowMetrica['comissao_dono'] + $rowMetrica['comissao_locacao'] + $rowMetrica['comissao_ponto'];
                                                $totalcomissaosocio += $rowMetrica['acerto'] - $comissoes;
                                            }
                                        }

                                        $totallocacao += $rowMetrica['comissao_dono'];

                                        $totaldono += $rowMetrica['comissao_locacao'];
                                    }

                                    //se é operador
                                } else {
//                                   
                                    $totaldono += $rowMetrica['saldo_total'] - $rowMetrica['comissao_ponto'];
                                    $totalsaldo += $total_saldo = $rowMetrica['saldo_total'];
                                    // $totalsaldo = $total_saldo = ($rowMetrica['comissao_dono'] + $rowMetrica['comissao_ponto'] + $rowMetrica['comissao_locacao']);
                                }
                                ?>
                                <tr>
                                    <td><?php echo $rowMetrica['idprod'] ?></td>
                                    <td width='200'><?php echo $_SESSION['cifraoMoeda'] . " " . $total_saldo ?></td>
                                </tr>

                                <?php
                            }
                            ?>
                        </tbody>
                    </table>
                    <br>
                    <table class="table table-striped table-bordered table-hover" >
                        <tbody>
                            <?php if ($_SESSION['UsuarioNivel'] != 6 && $_SESSION['UsuarioNivel'] != 1) { ?>
                                <tr><td class="text-right" ><strong>Locação a pagar:</strong> </td><td><?php echo $_SESSION['cifraoMoeda'] . " " . $totallocacao ?></td></tr>
                            <?php } elseif ($_SESSION['UsuarioNivel'] == 1) {
                                ?>
                                <tr><td class="text-right" ><strong>Comissão Cliente:</strong> </td><td><?php echo $_SESSION['cifraoMoeda'] . " " . $totallocacao ?></td></tr>
                            <?php } if ($_SESSION['UsuarioNivel'] == 6) { ?>
                                <tr><td class="text-right" ><strong>Comissão Locação:</strong> </td><td><?php echo $_SESSION['cifraoMoeda'] . " " . $totaldono ?></td></tr>
                            <?php } else { ?>
                                <tr><td class="text-right" ><strong>Minha Comissão:</strong> </td><td><?php echo $_SESSION['cifraoMoeda'] . " " . $totaldono ?></td></tr>
                            <?php } ?>
                            <tr><td class="text-right" ><strong>Comissão Ponto:</strong> </td><td><?php echo $_SESSION['cifraoMoeda'] . " " . $totalponto ?></td></tr>
                            <?php if ($totalcomissaosocio > 0) { ?>
                                <tr><td class="text-right" ><strong>Comissão Sócio:</strong> </td><td  width='200'><?php echo $_SESSION['cifraoMoeda'] . " " . $totalcomissaosocio ?></td></tr>
                            <?php } ?>
                            <tr><td class="text-right" ><strong>Total Saldo:</strong> </td><td  width='200'><strong><?php echo $_SESSION['cifraoMoeda'] . " " . $totalsaldo ?></strong></td></tr>

                        </tbody>
                    </table>
                </div>
                <!-- /.table-responsive -->
            </div>
        </div>
    </div>
    <div class="modal-footer">
        <button type="button" class="btn btn-default" data-dismiss="modal">Ok</button>
    </div>
    <?php
}
?>
