<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;
use App\Http\Controllers\PrincipalController;
/*
|--------------------------------------------------------------------------
| API Routes
|--------------------------------------------------------------------------
|
| Here is where you can register API routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| is assigned the "api" middleware group. Enjoy building your API!
|
*/

Route::middleware('auth:sanctum')->get('/user', function (Request $request) {
    return $request->user();
});

Route::prefix('tablet')->group(function(){
    Route::get('/login', 'Api\LoginController@loginDevice');

    Route::get('/tablet', 'Api\TabletController@tablet');

    Route::get('/status', 'Api\TabletController@verificaStatus');
   
    Route::get('/cadastro', 'Api\TabletController@cadastrar');
    
    Route::get('/leitura-realtime', 'Api\TabletController@sendLeituraRealtime');
    
    Route::get('/leitura-sender', 'Api\TabletController@sendleiturarealtime_dbsync');

    Route::get('/insert-coin', 'Api\TabletController@insertCredits');

    Route::get('/update', 'Api\TabletController@atualizarTablets');
    
    Route::post('/webhook', 'Api\LoginController@webhook');

    Route::post('/webhook/pix', 'Api\LoginController@webhookPix');

    Route::get('/teste', 'Api\LoginController@testes');

    Route::post('/teste-webhook', 'Api\LoginController@testeWebhook');
});


Route::prefix('pix')->group(function(){
    Route::post('/gerar-pix', 'Api\PixController@gerarPix');
    
    Route::post('/gerar-pix-suit-pay', 'Api\PixController@gerarPixSuitPay');
    
    Route::post('/transfere-pix', 'Api\PixController@transferirPix');
   
    Route::post('/transfere-pix-suit-pay', 'Api\PixController@transferirPixSuitPay');

    Route::post('/gerar-qrcode', 'Api\PixController@gerarQRCode');
    
    Route::post('/webhook', 'Api\PixController@webhookPix');
    
    Route::post('/webhook-suit-pay', 'Api\PixController@webhookPixSuitPay');

    Route::post('/webhook-send-pix', 'Api\PixController@webhookSendPix');

    Route::post('/webhook-transfer-pix', 'Api\PixController@webhookAsaas');
  

});
