const cacheName = "Nuno-Terminal-1.2";
const contentToCache = [
    "Build/web.loader.js",
    "Build/web.framework.js",
    "Build/web.data",
    "Build/web.wasm",
    "TemplateData/style.css"
];

self.addEventListener('install', function (e) {
    console.log('[Service Worker] Install');
    
    e.waitUntil((async function () {
      const cache = await caches.open(cacheName);
      console.log('[Service Worker] Caching all: app shell and content');
      await cache.addAll(contentToCache);
    })());
});

self.addEventListener('fetch', function (e) {
    e.respondWith((async function () {
        try {
            console.log(`[Service Worker] Fetching resource from network: ${e.request.url}`);
            const networkResponse = await fetch(e.request);
            return networkResponse;
        } catch (error) {
            console.error('[Service Worker] Fetch failed:', error);
            throw error;
        }
    })());
});
