<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use \App\Models\User;
use \App\Models\Ponto;
use \App\Models\Tablet;
use \App\Models\Cliente;
use \App\Models\Credito;
use \App\Models\Leitura;
use GuzzleHttp\Client;
use GuzzleHttp\Exception\ClientException;
use Illuminate\Http\Response;
use Hash;
use Session;
use DateTime;
use DateInterval;

class PixController extends Controller
{
    public function gerarPix(Request $request)
    {
        $dateTime = new DateTime();

        // Adicionar 5 minutos
        $dateTime->add(new DateInterval('PT5M'));

        // Formatar a data e hora
        $formattedDateTime = $dateTime->format('Y-m-d H:i:s');
        
        $client = new \GuzzleHttp\Client();

       
        if($request->token == "app") {
            $nome = $request->nome;
            $idprod = $request->idprod;
            $cpf = str_replace('.', '', $request->cpf);
            $cpf = str_replace('-', '',$cpf);
            $valor = $request->valor;

            // echo $valor . $cpf . $idprod;
            // return;
        }else {
            $nome = $request->input('user.nome');
            $idprod = $request->input('user.tablet.idprod');
            $cpf = str_replace('.', '', $request->input('user.cpf'));
            $cpf = str_replace('-', '',$cpf);
            $valor = $request->input('deposito.valor');
        }
              
        $valorCobranca =number_format($valor,'2');
        $sandbox = false;
        // $valorCobranca =strval($valorCobranca);
        //3bdc6b66-6115-4e6c-8feb-a9727f5298c3 comp
        //chave oficial 3bdc6b66-6115-4e6c-8feb-a9727f5298c3	

        $data = [
            // 'customer' => 'cus_000074096837',//original camp
            // 'customer' => 'cus_000005810756', // sand comp
            // 'customer' => 'cus_000005817211', // sand paulo
            // 'customer' => 'cus_000077700147', // prod alex
            'customer' => 'cus_000074999444', // Original  paulo
            'billingType' => 'PIX',
            'value' => $valorCobranca,
            'format' => 'ALL', 
            'dueDate' => $formattedDateTime, 
            'description' => $idprod, 
        ];
        
        try {
            $response = $client->request('POST', urlApi($sandbox).'payments', [
                'headers' => [
                    'accept' => 'application/json',
                    'access_token' =>  access_token($sandbox),
                    'content-type' => 'application/json',
                ],
                'json' => $data, 
            ]);
            

            echo $response->getBody();
            
        
        } catch (\Exception $e) {
            echo $e;
        } catch (ClientException $e){
            $response = $e->getResponse();
            $statusCode = $response->getStatusCode();
            $conteudo = $response->getBody()->getContents();
        }
    }
    
    public function gerarPixSuitPay(Request $request)
    {
        
        $dateTime = new DateTime();

        // Adicionar 5 minutos
        $dateTime->add(new DateInterval('PT5M'));

        // Formatar a data e hora
        // $formattedDateTime = $dateTime->format('Y-m-d H:i:s');
        $formattedDateTime = $dateTime->format('Y-m-d');
        
        $client = new \GuzzleHttp\Client();

        if($request->token == "app") {
            $nome = $request->nome;
            $idprod = $request->idprod;
            $cpf = str_replace('.', '', $request->cpf);
            $cpf = str_replace('-', '',$cpf);
            $valor = $request->valor;

            // echo $valor . $cpf . $idprod;
            // return;
        }else {
            $nome = $request->input('user.nome');
            $idprod = $request->input('user.tablet.idprod');
            $cpf = str_replace('.', '', $request->input('user.cpf'));
            $cpf = str_replace('-', '',$cpf);
            $valor = $request->input('deposito.valor');
        }
              
        $valorCobranca =number_format($valor,'2');
        $sandbox = true;
    
        $data = [
            'requestNumber' => $idprod, 
            'dueDate' => $formattedDateTime, 
            'amount' => $valor, 
            'shippingAmount' => 0.0, 
            'discountAmount' => 0.0, 
            'callbackUrl' => 'https://admin.pixbetmaster.com.br/public/api/pix/webhook-suit-pay',
            'client' => [
                'name'=> $nome,
                'document' => '35077529809',
            ],
               
        ];
        
        try {
            $response = $client->request('POST', urlSuitPay($sandbox).'/api/v1/gateway/request-qrcode', [
                'headers' => [
                    'accept' => 'application/json',
                    'ci' =>  access_token_suipPay('client_id', $sandbox),
                    'cs' =>  access_token_suipPay('secret_id', $sandbox),
                    'content-type' => 'application/json',
                ],
                'json' => $data, 
            ]);
            

            echo $response->getBody();
            
        
        } catch (\Exception $e) {
            echo $e;
        } catch (ClientException $e){
            $response = $e->getResponse();
            $statusCode = $response->getStatusCode();
            $conteudo = $response->getBody()->getContents();
        }
    }

    public function gerarQRCode(Request $request)
    {   
        $client = new \GuzzleHttp\Client();

        $sandbox = false;

        $id = $request->input('id');
        
        $response = $client->request('GET', urlApi($sandbox).'payments/'. $id .'/pixQrCode', [
        'headers' => [
            'accept' => 'application/json',
            'access_token' =>  access_token($sandbox),
        ],
        
        ]);

        echo $response->getBody();
    }

    public function transferirPix(Request $request)
    {
        if($request->token == "app") {
            
            $cliente = Cliente::where('cpf', '=', $request->cpf)->first();

            $velue = $request->input('value');
            $operationType = 'PIX';
            $pixAddressKey =  $cliente->chave_pix;
            $pixAddressKeyType = $cliente->tipo_pix;
            $description = 'assistência remoto';
            $idprod = $cliente->cpf; 
           
          
        } else {
            $velue = $request->input('value');
            $operationType = 'PIX';
            $pixAddressKey = $request->input('keyPix');
            $pixAddressKeyType = $request->input('pixType');
            $description = 'assistência remoto';
            $idprod = $request->input('idprod'); 
        }
      
        //dd($credito);
        $client = new \GuzzleHttp\Client();

        $sandbox = false;

        $data = [
            'value' => $velue, 
            'operationType' => $operationType,
            'pixAddressKey' => $pixAddressKey,
            'pixAddressKeyType' => $pixAddressKeyType, 
            'description' => $description, 
             
        ];
        
        try {
            $response = $client->request('POST', urlApi($sandbox).'transfers', [
                'headers' => [
                    'accept' => 'application/json',
                    'access_token' =>  access_token($sandbox),
                    'content-type' => 'application/json',
                ],
                'json' => $data, 
            ]);
           
            $credito = Credito::where('idprod', '=', $idprod)->first();
            $credito->valor = "-7";
            $credito->save();
            echo $response->getBody();
           
            
        
        } catch (\Exception $e) {
            $errorMessage = json_decode($e->getResponse()->getBody()->getContents())->errors[0]->description ?? null;
            
            if ($errorMessage !== null) {
                // Agora você tem a mensagem de erro disponível em $errorMessage
                return response()->json($errorMessage, 400);
            } else {
                // Lidar com falha na decodificação do JSON ou outras situações inesperadas
                echo "Erro ao obter a mensagem de erro";
            }

        } catch (ClientException $e){
            $response = $e->getResponse();
            $statusCode = $response->getStatusCode();
            $conteudo = $response->getBody()->getContents();
        }
    }

    public function transferirPixSuitPay(Request $request)
    {
        //dd($request->all());
        $key = $request->input('key');
        $typeKey = $request->input('typeKey');
        $value = number_format($request->input('value'),'2') ;
        $idprod = $request->input('idprod');
        
        if($typeKey == 'CPF/CNPJ'){
            $typeKey = 'document';
        }else if($typeKey == "CELULAR"){
            $typeKey = 'phoneNumber';
        }else if($typeKey == "EMAIL"){
            $typeKey = 'email';
        }else if($typeKey == "CHAVE ALEATÓRIA"){
            $typeKey = 'randomKey';
        }

        $client = new \GuzzleHttp\Client();

        $sandbox = true;

        $data = [
            'key' => $key, 
            'typeKey' => $typeKey,
            'value' => $value,
            'callbackUrl' => 'https://webhook.site/e003db5a-7b95-483f-acbf-23aafdc15160',          
        ];
        
        try {
            $response = $client->request('POST', urlSuitPay($sandbox).'/api/v1/gateway/pix-payment', [
                'headers' => [
                    'accept' => 'application/json',
                    'ci' =>  access_token_suipPay('client_id', $sandbox),
                    'cs' =>  access_token_suipPay('secret_id', $sandbox),
                    'content-type' => 'application/json',
                ],
                'json' => $data, 
            ]);
           
            $credito = Credito::where('idprod', '=', $idprod)->first();
            $credito->valor = "-7";
            $credito->save();
            echo $response->getBody();
                
        } catch (ClientException $e) {
            $response = $e->getResponse();
            if ($response !== null) {
                $body = $response->getBody()->getContents();
                $json = json_decode($body, true);
                if (isset($json['response']) && $json['response'] === 'PIX_KEY_NOT_FOUND') {
                    // Se a chave PIX não for encontrada, faça algo com essa informação
                    echo $json['response'];
                } else {
                    // Caso contrário, manipule a resposta de outra forma
                    echo $json['response'];
                }
            } else {
                // Caso não haja uma resposta, trate o erro de outra forma
                echo 'Erro desconhecido: ' . $e->getMessage();
            }
        }
    }


    //webhook
    public function webhookPix(Request $request) 
    {
        $data_now = date('Y-m-d H:i:s');
        
        $paymentStatus = $request->input('payment.status');

        $idprod = $request->input('payment.description');

        $valor = $request->input('payment.value');
        
        $valor = number_format($valor,'2');
        
        $valor = strval($valor);
        // Validação caso o pagamento estiver pendente.
        if (empty($idprod)) {
            $dados = $request->all();
                
            // Converte o array associativo em uma string JSON
            $jsonString = json_encode($dados, JSON_PRETTY_PRINT);

            // Especifica o caminho e o nome do arquivo
            $caminhoArquivo = storage_path('app/json/arquivo.json');

            // Salva a string JSON no arquivo
            file_put_contents($caminhoArquivo, $jsonString);

            return response()->json(['mensagem' => 'Arquivo JSON criado e salvo com sucesso.']);
        
        }else{
            if( $paymentStatus == "RECEIVED") {

                $creditos = Credito::where('idprod', '=', $idprod)->first();
    
                if(!$creditos){
                    $creditos = new Credito;
                    $creditos->idprod = $idprod ;
                    $creditos->data =  $data_now;
                    $creditos->valor = $valor;
                    $creditos->status = '1';
                    $creditos->tipo = '1';
                    $creditos->save();
                    
                }else{
                    $creditos->valor = $valor;
                    $creditos->status = '1';
                    $creditos->save();
                
                }
    
                
            }else {
                $dados = $request->all();
                
                // Converte o array associativo em uma string JSON
                $jsonString = json_encode($dados, JSON_PRETTY_PRINT);
    
                // Especifica o caminho e o nome do arquivo
                $caminhoArquivo = storage_path('app/json/arquivo.json');
    
                // Salva a string JSON no arquivo
                file_put_contents($caminhoArquivo, $jsonString);
    
                return response()->json(['mensagem' => 'Arquivo JSON criado e salvo com sucesso.']);
            }   
        }

        
    }

    public function webhookPixSuitPay(Request $request) 
    {
        $data_now = date('Y-m-d H:i:s');
        
        $paymentStatus = $request->input('statusTransaction');

        $idprod = $request->input('requestNumber');

        $valor = $request->input('value');
        
        $valor = number_format($valor,'2');
        
        $valor = strval($valor);
        // Validação caso o pagamento estiver pendente.
        if (empty($idprod)) {
            $dados = $request->all();
                
            // Converte o array associativo em uma string JSON
            $jsonString = json_encode($dados, JSON_PRETTY_PRINT);

            // Especifica o caminho e o nome do arquivo
            $caminhoArquivo = storage_path('app/json/arquivo.json');

            // Salva a string JSON no arquivo
            file_put_contents($caminhoArquivo, $jsonString);

            return response()->json(['mensagem' => 'Arquivo JSON criado e salvo com sucesso.']);
        
        }else{
            if( $paymentStatus == "PAID_OUT") {

                $creditos = Credito::where('idprod', '=', $idprod)->first();
    
                if(!$creditos){
                    $creditos = new Credito;
                    $creditos->idprod = $idprod ;
                    $creditos->data =  $data_now;
                    $creditos->valor = $valor;
                    $creditos->status = '1';
                    $creditos->tipo = '1';
                    $creditos->save();
                    
                }else{
                    $creditos->valor = $valor;
                    $creditos->status = '1';
                    $creditos->save();
                
                }
    
                
            }else {
                $dados = $request->all();
                
                // Converte o array associativo em uma string JSON
                $jsonString = json_encode($dados, JSON_PRETTY_PRINT);
    
                // Especifica o caminho e o nome do arquivo
                $caminhoArquivo = storage_path('app/json/arquivo.json');
    
                // Salva a string JSON no arquivo
                file_put_contents($caminhoArquivo, $jsonString);
    
                return response()->json(['mensagem' => 'Arquivo JSON criado e salvo com sucesso.']);
            }   
        }

        
    }

    public function webhookSendPix(Request $request)
    {
        return response()->json('Teste webhookSendPix', 200);
    }
}
