<?php

namespace App\Http\Controllers;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use \App\Models\User;
use \App\Models\Ponto;
use \App\Models\Tablet;
use \App\Models\Credito;
use Illuminate\Http\Response;
use Hash;
use Session;

use Efi\Exception\EfiException;
use Efi\EfiPay;

class PixController extends Controller
{
    public function gerarPix(Request $request)
    {

        $nome = $request->input('user.nome');
        $idprod = $request->input('user.tablet.idprod');
        $cpf = str_replace('.', '', $request->input('user.cpf'));
        $cpf = str_replace('-', '',$cpf);
        $valor = $request->input('deposito.valor');

        $valorCobranca =number_format($valor,'2');
        
        $valorCobranca =strval($valorCobranca);
        
        // dd($idprod);
        
        $options = optionPay();
       
        $body = [
            "calendario" => [
                "expiracao" => 3600 // Charge lifetime, specified in seconds from creation date
            ],
            "devedor" => [
                "cpf" => $cpf,
                "nome" => $nome,
                
            ],
            "valor" => [
                "original" => $valorCobranca,
            ],
            "chave" => "05d8c95a-ea71-48db-be1a-914aaeb2aba4", // Pix key registered in the authenticated Efí account
            // "solicitacaoPagador" => "Enter the order number or identifier.",
            "infoAdicionais" => [
                [
                    "nome" => $idprod,
                    "valor" =>  $valorCobranca,
                ],
            ]
        ];

        try {
            $api = new EfiPay($options);
            $pix = $api->pixCreateImmediateCharge($params = [], $body); // Using this function the txid will be generated automatically by Efí API
        
            if ($pix["txid"]) {
                $params = [
                    "id" => $pix["loc"]["id"]
                ];
        
                try {
                    $qrcode = $api->pixGenerateQRCode($params);
        
                    // echo "<b>Detalhes da cobrança:</b>";
                    // echo "<b>" . json_encode($pix, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) . "</b>";
        
                    // echo "<b>QR Code:</b>";
                    // echo "<pre>" . json_encode($qrcode, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) . "</pre>";
                    
                    // echo "<b>Imagem:</b><br />";
                    // echo "<img src='" . $qrcode["imagemQrcode"] . "' />";
                    
                    return response()->json(['qrcode' => $qrcode], 200);

                } catch (EfiException $e) {
                    print_r($e->code . "<br>");
                    print_r($e->error . "<br>");
                    print_r($e->errorDescription . "<br>");
                } catch (Exception $e) {
                    print_r($e->getMessage());
                }
            } else {
                echo "<pre>" . json_encode($pix, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) . "</pre>";
            }
        } catch (EfiException $e) {
            print_r($e->code . "<br>");
            print_r($e->error . "<br>");
            print_r($e->errorDescription . "<br>");
        } catch (Exception $e) {
            print_r($e->getMessage());
        }
    }

    public function configWebHook(Request $request)
    {
        $options = optionPay();
        
        $options["headers"] = [
            "x-skip-mtls-checking" => "true",
        ];
        
        $params = [
            "chave" => "05d8c95a-ea71-48db-be1a-914aaeb2aba4"
        ];
        
        $body = [
            "webhookUrl" => "https://kioskoficial.taz.app.br/public/api/tablet/webhook"
        ];
        
        try {
            $api = new EfiPay($options);
            $response = $api->pixConfigWebhook($params, $body);
            
            return response()->json(['webhook' => $response], 200);

        } catch (EfiException $e) {
           
            print_r($e->code . "<br>");
            print_r($e->error . "<br>");
            print_r($e->errorDescription) . "<br>";
        } catch (Exception $e) {
            print_r($e->getMessage());
        }

        // $params = [
        //     "chave" => "05d8c95a-ea71-48db-be1a-914aaeb2aba4"
        // ];
        
        // try {
        //     $api = new EfiPay($options);
        //     $response = $api->pixDeleteWebhook($params);
        
        //     print_r("<pre>" . json_encode($response, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES) . "</pre>");
        // } catch (EfiException $e) {
        //     print_r($e->code . "<br>");
        //     print_r($e->error . "<br>");
        //     print_r($e->errorDescription) . "<br>";
        // } catch (Exception $e) {
        //     print_r($e->getMessage());
        // }
    }

    public function configNotification(Request $request)
    {
        $options = optionPay();
       
        $metadata = array('notification_url'=>'https://webhook.site/84aaf6a6-2427-4c06-90b8-9bba0445b652');
        
        $body = [
        'items' => $items,
        'metadata' => $metadata
        ];
        
        try {
        $api = new Efí($options);
        
        $charge = $api->createCharge([], $body);

        echo $charge;

        }catch (EfiException $e) {
            print_r($e->code . "<br>");
            print_r($e->error . "<br>");
            print_r($e->errorDescription) . "<br>";
        } catch (Exception $e) {
            print_r($e->getMessage());
        }

    }


    public function webhook(Request $request)
    {
        $payload = $request->all();

        return response()->json(['status' => 200],201);
    }

    public function resposta($status, $mensagem, $dados)
    {
   
        
        return response()->json("Requisição realizada com sucesso!", 200);

    
        
    }

    public function requisicao($metodo, $body, $parametros)
    {
        switch ($metodo) {
            case 'POST':
                $this->salvar($body);
            break;
            case 'GET':
                $this->resposta(200, "Requisição realizada com sucesso!", $body);
            break;
        }
    }

    public function salvar($dados)
    {
        // Crie um arquivo .;json para salvar as informações
        $nomeArquivo = './dados.json';
        $dadosGravados = json_decode(file_get_contents($nomeArquivo), true);
        $arquivo = fopen($nomeArquivo, 'w');

        // Incrementa as informações enviadas com o que já havia gravado
        array_push($dadosGravados, $dados);

        if (fwrite($arquivo, json_encode($dadosGravados))) {
            resposta(200, "Requisição realizada com sucesso!", $dados);
        } else {
            resposta(300, "Falha ao salvar os dados da requisição.", $dados);
        }

        fclose($arquivo);
    }

    public function webhookPix(Request $request)
    {
        return response()->json("Requisição realizada com sucesso!", 200);

    }

    
    // public function webhook(Request $request)
    // {
    //     return response()->json("", 200);
    //     // $data_now = date('Y-m-d H:i:s');

    //     // // $txid = '2f7ad228fa074b3a9c67f1ecf98b07e6';
    //     // // $valor = '0.01' ;

    //     // $txid = $request->input('pix.txid');
    //     // $valor = $response['infoAdicionais'][0]['valor'];
    
    //     // //Teste depois remover a linha abaixo
    //     // if($valor <= '1'){
    //     //     $valor = '10.00';
    //     // }

    //     // $options = optionPay();

    //     // $params = [
    //     //     "txid" =>  $txid
    //     // ];
        
    //     // try {
    //     //     $api = new EfiPay($options);
    //     //     $response = $api->pixDetailCharge($params);
            
    //     //     if($response['status'] == "CONCLUIDA"){
    //     //         $creditos = Credito::where('idprod', '=', $response['infoAdicionais'][0]['nome'])->first();
    //     //         if(!$creditos){
    //     //             $creditos = new Credito;
    //     //             $creditos->idprod =  '419E';
    //     //             $creditos->data =  $data_now;
    //     //             $creditos->valor = $valor;
    //     //             $creditos->status = '1';
    //     //             $creditos->tipo = '1';
    //     //             $creditos->save();
    //     //         }else{
    //     //             $creditos->valor = $valor;
    //     //             $creditos->status = '1';
    //     //             $creditos->save();
    //     //         }
    //     //     }

    //     //     return response()->json(['status' => $response['status']], 200);
    //     // } catch (EfiException $e) {
    //     //     print_r($e->code . "<br>");
    //     //     print_r($e->error . "<br>");
    //     //     print_r($e->errorDescription) . "<br>";
    //     // } catch (Exception $e) {
    //     //     print_r($e->getMessage());
    //     // }
    // }

    // public function notification(Request $request)
    // {

    //     $options = optionPay();

    //     $params = [
    //         "txid" => "2f7ad228fa074b3a9c67f1ecf98b07e6"
    //     ];
        
    //     try {
    //         $api = new EfiPay($options);
    //         $response = $api->pixDetailCharge($params);
        
    //         dd($response['infoAdicionais'][0]['valor']);
    //     } catch (EfiException $e) {
    //         print_r($e->code . "<br>");
    //         print_r($e->error . "<br>");
    //         print_r($e->errorDescription) . "<br>";
    //     } catch (Exception $e) {
    //         print_r($e->getMessage());
    //     }
        
    // }


}
