<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use DB;
use App\User;

class DatabaseSeeder extends Seeder
{
    /**
     * Seed the application's database.
     *
     * @return void
     */
    public function run()
    {
        // \App\Models\User::factory(10)->create();
        $this->call(UserAdmin::class);
        // $this->call(UserRegiao::class);
        // $this->call(UserNivel::class);
        // $this->call(UserStatus::class);
        // $this->call(TabletConfig::class);
        // $this->call(Ponto::class);
     
    }

   
}

class UserNivel extends Seeder {
    
    public function run()
    {
        DB::table('user_nivel')->truncate();

        DB::insert(DB::raw("
            INSERT INTO `user_nivel` (`id_user_nivel`, `nivel_user`, `nivel_sigla`, `ativo`) VALUES
            (1, 'Administrador', 'admin', 1),
            (2, 'Sub-Administrador', 'subadmin', 1),
            (3, 'Cliente', 'cliente', 1),
            (4, 'Sócio', 'socio', 1),
            (5, 'Funcionário', 'funcionario', 1),
            (6, 'Operador', 'operador', 1)
        "));

        $this->command->info('Nivel de usuários inseridas!');
    }
    
}

class UserStatus extends Seeder {
    
    public function run()
    {
        DB::table('user_status')->truncate();

        DB::insert(DB::raw("
            INSERT INTO `user_status` (`id_user_status`, `status_txt`, `ativo`) VALUES
            (1, 'Ativo', 1),
            (2, 'Bloqueado', 1),
            (4, 'Excluído', 1)
        "));

        $this->command->info('User status inserido!');
    }
    
}

class TabletConfig extends Seeder {
    
    public function run()
    {
        DB::table('tablet_config')->truncate();

        DB::insert(DB::raw("
            INSERT INTO `tablet_config` (`id`, `versao`) VALUES
            (1, '1.0.2');
        "));

        $this->command->info('Tablet config inserido!');
    }
    
}

class Ponto extends Seeder {
    
    public function run()
    {
        DB::table('ponto')->truncate();

        DB::insert(DB::raw("
        INSERT INTO `ponto` (`id`, `nome`, `porcent_ponto`, `cadastro`, `id_apoio`, `status`, `passwd`, `modo`) VALUES
            (13, 'Usuário Paty Mollo', 0, '2023-11-17 03:01:21', 1, 1, '', 0);
        "));

        $this->command->info('Ponto inserido!');
    }
    
}

class UserRegiao extends Seeder {
    
    public function run()
    {
        DB::table('user_status')->truncate();

        DB::insert(DB::raw("
            INSERT INTO `regiao` (`id_pais`, `nome_pais`, `name_pais`, `moeda_sigla`, `status`, `timezone`) VALUES
            (1, 'AFEGANISTÃO', 'AFGHANISTAN', NULL, 0, NULL),
            (2, 'ACROTÍRI E DECELIA', 'AKROTIRI E DEKÉLIA', NULL, 0, NULL),
            (3, 'ÁFRICA DO SUL', 'SOUTH AFRICA', NULL, 0, NULL),
            (4, 'ALBÂNIA', 'ALBANIA', NULL, 0, NULL),
            (5, 'ALEMANHA', 'GERMANY', NULL, 0, 'Europe/Berlin'),
            (6, 'AMERICAN SAMOA', 'AMERICAN SAMOA', NULL, 0, NULL),
            (7, 'ANDORRA', 'ANDORRA', NULL, 0, NULL),
            (8, 'ANGOLA', 'ANGOLA', NULL, 0, NULL),
            (9, 'ANGUILLA', 'ANGUILLA', NULL, 0, NULL),
            (10, 'ANTÍGUA E BARBUDA', 'ANTIGUA AND BARBUDA', NULL, 0, NULL),
            (11, 'ANTILHAS NEERLANDESAS', 'NETHERLANDS ANTILLES', NULL, 0, NULL),
            (12, 'ARÁBIA SAUDITA', 'SAUDI ARABIA', NULL, 0, NULL),
            (13, 'ARGÉLIA', 'ALGERIA', NULL, 0, NULL),
            (14, 'ARGENTINA', 'ARGENTINA', NULL, 0, NULL),
            (15, 'ARMÉNIA', 'ARMENIA', NULL, 0, NULL),
            (16, 'ARUBA', 'ARUBA', NULL, 0, NULL),
            (17, 'AUSTRÁLIA', 'AUSTRALIA', NULL, 0, NULL),
            (18, 'ÁUSTRIA', 'AUSTRIA', NULL, 0, NULL),
            (19, 'AZERBAIJÃO', 'AZERBAIJAN', NULL, 0, NULL),
            (20, 'BAHAMAS', 'BAHAMAS, THE', NULL, 0, NULL),
            (21, 'BANGLADECHE', 'BANGLADESH', NULL, 0, NULL),
            (22, 'BARBADOS', 'BARBADOS', NULL, 0, NULL),
            (23, 'BARÉM', 'BAHRAIN', NULL, 0, NULL),
            (24, 'BASSAS DA ÍNDIA', 'BASSAS DA INDIA', NULL, 0, NULL),
            (25, 'BÉLGICA', 'BELGIUM', NULL, 0, NULL),
            (26, 'BELIZE', 'BELIZE', NULL, 0, NULL),
            (27, 'BENIM', 'BENIN', NULL, 0, NULL),
            (28, 'BERMUDAS', 'BERMUDA', NULL, 0, NULL),
            (29, 'BIELORRÚSSIA', 'BELARUS', NULL, 0, NULL),
            (30, 'BOLÍVIA', 'BOLIVIA', NULL, 0, NULL),
            (31, 'BÓSNIA E HERZEGOVINA', 'BOSNIA AND HERZEGOVINA', NULL, 0, NULL),
            (32, 'BOTSUANA', 'BOTSWANA', NULL, 0, NULL),
            (33, 'BRASIL', 'BRAZIL', 'R$', 1, 'America/Sao_Paulo'),
            (34, 'BRUNEI DARUSSALAM', 'BRUNEI DARUSSALAM', NULL, 0, NULL),
            (35, 'BULGÁRIA', 'BULGARIA', NULL, 0, NULL),
            (36, 'BURQUINA FASO', 'BURKINA FASO', NULL, 0, NULL),
            (37, 'BURUNDI', 'BURUNDI', NULL, 0, NULL),
            (38, 'BUTÃO', 'BHUTAN', NULL, 0, NULL),
            (39, 'CABO VERDE', 'CAPE VERDE', NULL, 0, NULL),
            (40, 'CAMARÕES', 'CAMEROON', NULL, 0, NULL),
            (41, 'CAMBOJA', 'CAMBODIA', NULL, 0, NULL),
            (42, 'CANADÁ', 'CANADA', NULL, 0, NULL),
            (43, 'CATAR', 'QATAR', NULL, 0, NULL),
            (44, 'CAZAQUISTÃO', 'KAZAKHSTAN', NULL, 0, NULL),
            (45, 'CENTRO-AFRICANA REPÚBLICA', 'CENTRAL AFRICAN REPUBLIC', NULL, 0, NULL),
            (46, 'CHADE', 'CHAD', NULL, 0, NULL),
            (47, 'CHILE', 'CHILE', NULL, 0, NULL),
            (48, 'CHINA', 'CHINA', NULL, 0, NULL),
            (49, 'CHIPRE', 'CYPRUS', NULL, 0, NULL),
            (50, 'COLÔMBIA', 'COLOMBIA', NULL, 0, NULL),
            (51, 'COMORES', 'COMOROS', NULL, 0, NULL),
            (52, 'CONGO', 'CONGO', NULL, 0, NULL),
            (53, 'CONGO REPÚBLICA DEMOCRÁTICA', 'CONGO DEMOCRATIC REPUBLIC', NULL, 0, NULL),
            (54, 'COREIA DO NORTE', 'KOREA NORTH', NULL, 0, NULL),
            (55, 'COREIA DO SUL', 'KOREA SOUTH', NULL, 0, NULL),
            (56, 'COSTA DO MARFIM', 'IVORY COAST', NULL, 0, NULL),
            (57, 'COSTA RICA', 'COSTA RICA', NULL, 0, NULL),
            (58, 'CROÁCIA', 'CROATIA', NULL, 0, NULL),
            (59, 'CUBA', 'CUBA', NULL, 0, NULL),
            (60, 'DINAMARCA', 'DENMARK', NULL, 0, NULL),
            (61, 'DOMÍNICA', 'DOMINICA', NULL, 0, NULL),
            (62, 'EGIPTO', 'EGYPT', NULL, 0, NULL),
            (63, 'EMIRADOS ÁRABES UNIDOS', 'UNITED ARAB EMIRATES', NULL, 0, NULL),
            (64, 'EQUADOR', 'ECUADOR', NULL, 0, NULL),
            (65, 'ERITREIA', 'ERITREA', NULL, 0, NULL),
            (66, 'ESLOVÁQUIA', 'SLOVAKIA', NULL, 0, NULL),
            (67, 'ESLOVÉNIA', 'SLOVENIA', NULL, 0, NULL),
            (68, 'ESPANHA', 'SPAIN', NULL, 0, 'Europe/Madrid'),
            (69, 'ESTADOS UNIDOS', 'UNITED STATES', NULL, 0, 'America/New_York'),
            (70, 'ESTÓNIA', 'ESTONIA', NULL, 0, NULL),
            (71, 'ETIÓPIA', 'ETHIOPIA', NULL, 0, NULL),
            (72, 'FAIXA DE GAZA', 'GAZA STRIP', NULL, 0, NULL),
            (73, 'FIJI', 'FIJI', NULL, 0, NULL),
            (74, 'FILIPINAS', 'PHILIPPINES', NULL, 0, NULL),
            (75, 'FINLÂNDIA', 'FINLAND', NULL, 0, NULL),
            (76, 'FRANÇA', 'FRANCE', NULL, 0, NULL),
            (77, 'GABÃO', 'GABON', NULL, 0, NULL),
            (78, 'GÂMBIA', 'GAMBIA', NULL, 0, NULL),
            (79, 'GANA', 'GHANA', NULL, 0, NULL),
            (80, 'GEÓRGIA', 'GEORGIA', NULL, 0, NULL),
            (81, 'GIBRALTAR', 'GIBRALTAR', NULL, 0, NULL),
            (82, 'GRANADA', 'GRENADA', NULL, 0, NULL),
            (83, 'GRÉCIA', 'GREECE', NULL, 0, NULL),
            (84, 'GRONELÂNDIA', 'GREENLAND', NULL, 0, NULL),
            (85, 'GUADALUPE', 'GUADELOUPE', NULL, 0, NULL),
            (86, 'GUAM', 'GUAM', NULL, 0, NULL),
            (87, 'GUATEMALA', 'GUATEMALA', NULL, 0, NULL),
            (88, 'GUERNSEY', 'GUERNSEY', NULL, 0, NULL),
            (89, 'GUIANA', 'GUYANA', NULL, 0, NULL),
            (90, 'GUIANA FRANCESA', 'FRENCH GUIANA', NULL, 0, NULL),
            (91, 'GUINÉ', 'GUINEA', NULL, 0, NULL),
            (92, 'GUINÉ EQUATORIAL', 'EQUATORIAL GUINEA', NULL, 0, NULL),
            (93, 'GUINÉ-BISSAU', 'GUINEA-BISSAU', NULL, 0, NULL),
            (94, 'HAITI', 'HAITI', NULL, 0, NULL),
            (95, 'HONDURAS', 'HONDURAS', NULL, 0, NULL),
            (96, 'HONG KONG', 'HONG KONG', NULL, 0, NULL),
            (97, 'HUNGRIA', 'HUNGARY', NULL, 0, NULL),
            (98, 'IÉMEN', 'YEMEN', NULL, 0, NULL),
            (99, 'ILHA BOUVET', 'BOUVET ISLAND', NULL, 0, NULL),
            (100, 'ILHA CHRISTMAS', 'CHRISTMAS ISLAND', NULL, 0, NULL),
            (101, 'ILHA DE CLIPPERTON', 'CLIPPERTON ISLAND', NULL, 0, NULL),
            (102, 'ILHA DE JOÃO DA NOVA', 'JUAN DE NOVA ISLAND', NULL, 0, NULL),
            (103, 'ILHA DE MAN', 'ISLE OF MAN', NULL, 0, NULL),
            (104, 'ILHA DE NAVASSA', 'NAVASSA ISLAND', NULL, 0, NULL),
            (105, 'ILHA EUROPA', 'EUROPA ISLAND', NULL, 0, NULL),
            (106, 'ILHA NORFOLK', 'NORFOLK ISLAND', NULL, 0, NULL),
            (107, 'ILHA TROMELIN', 'TROMELIN ISLAND', NULL, 0, NULL),
            (108, 'ILHAS ASHMORE E CARTIER', 'ASHMORE AND CARTIER ISLANDS', NULL, 0, NULL),
            (109, 'ILHAS CAIMAN', 'CAYMAN ISLANDS', NULL, 0, NULL),
            (110, 'ILHAS COCOS (KEELING)', 'COCOS (KEELING) ISLANDS', NULL, 0, NULL),
            (111, 'ILHAS COOK', 'COOK ISLANDS', NULL, 0, NULL),
            (112, 'ILHAS DO MAR DE CORAL', 'CORAL SEA ISLANDS', NULL, 0, NULL),
            (113, 'ILHAS FALKLANDS (ILHAS MALVINAS)', 'FALKLAND ISLANDS (ISLAS MALVINAS)', NULL, 0, NULL),
            (114, 'ILHAS FEROE', 'FAROE ISLANDS', NULL, 0, NULL),
            (115, 'ILHAS GEÓRGIA DO SUL E SANDWICH DO SUL', 'SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS', NULL, 0, NULL),
            (116, 'ILHAS MARIANAS DO NORTE', 'NORTHERN MARIANA ISLANDS', NULL, 0, NULL),
            (117, 'ILHAS MARSHALL', 'MARSHALL ISLANDS', NULL, 0, NULL),
            (118, 'ILHAS PARACEL', 'PARACEL ISLANDS', NULL, 0, NULL),
            (119, 'ILHAS PITCAIRN', 'PITCAIRN ISLANDS', NULL, 0, NULL),
            (120, 'ILHAS SALOMÃO', 'SOLOMON ISLANDS', NULL, 0, NULL),
            (121, 'ILHAS SPRATLY', 'SPRATLY ISLANDS', NULL, 0, NULL),
            (122, 'ILHAS VIRGENS AMERICANAS', 'UNITED STATES VIRGIN ISLANDS', NULL, 0, NULL),
            (123, 'ILHAS VIRGENS BRITÂNICAS', 'BRITISH VIRGIN ISLANDS', NULL, 0, NULL),
            (124, 'ÍNDIA', 'INDIA', NULL, 0, NULL),
            (125, 'INDONÉSIA', 'INDONESIA', NULL, 0, NULL),
            (126, 'IRÃO', 'IRAN', NULL, 0, NULL),
            (127, 'IRAQUE', 'IRAQ', NULL, 0, NULL),
            (128, 'IRLANDA', 'IRELAND', NULL, 0, NULL),
            (129, 'ISLÂNDIA', 'ICELAND', NULL, 0, NULL),
            (130, 'ISRAEL', 'ISRAEL', NULL, 0, NULL),
            (131, 'ITÁLIA', 'ITALY', NULL, 0, NULL),
            (132, 'JAMAICA', 'JAMAICA', NULL, 0, NULL),
            (133, 'JAN MAYEN', 'JAN MAYEN', NULL, 0, NULL),
            (134, 'JAPÃO', 'JAPAN', NULL, 0, NULL),
            (135, 'JERSEY', 'JERSEY', NULL, 0, NULL),
            (136, 'JIBUTI', 'DJIBOUTI', NULL, 0, NULL),
            (137, 'JORDÂNIA', 'JORDAN', NULL, 0, NULL),
            (138, 'KIRIBATI', 'KIRIBATI', NULL, 0, NULL),
            (139, 'KOWEIT', 'KUWAIT', NULL, 0, NULL),
            (140, 'LAOS', 'LAOS', NULL, 0, NULL),
            (141, 'LESOTO', 'LESOTHO', NULL, 0, NULL),
            (142, 'LETÓNIA', 'LATVIA', NULL, 0, NULL),
            (143, 'LÍBANO', 'LEBANON', NULL, 0, NULL),
            (144, 'LIBÉRIA', 'LIBERIA', NULL, 0, NULL),
            (145, 'LÍBIA', 'LIBYAN ARAB JAMAHIRIYA', NULL, 0, NULL),
            (146, 'LISTENSTAINE', 'LIECHTENSTEIN', NULL, 0, NULL),
            (147, 'LITUÂNIA', 'LITHUANIA', NULL, 0, NULL),
            (148, 'LUXEMBURGO', 'LUXEMBOURG', NULL, 0, NULL),
            (149, 'MACAU', 'MACAO', NULL, 0, NULL),
            (150, 'MACEDÓNIA', 'MACEDONIA', NULL, 0, NULL),
            (151, 'MADAGÁSCAR', 'MADAGASCAR', NULL, 0, NULL),
            (152, 'MALÁSIA', 'MALAYSIA', NULL, 0, NULL),
            (153, 'MALAVI', 'MALAWI', NULL, 0, NULL),
            (154, 'MALDIVAS', 'MALDIVES', NULL, 0, NULL),
            (155, 'MALI', 'MALI', NULL, 0, NULL),
            (156, 'MALTA', 'MALTA', NULL, 0, NULL),
            (157, 'MARROCOS', 'MOROCCO', NULL, 0, NULL),
            (158, 'MARTINICA', 'MARTINIQUE', NULL, 0, NULL),
            (159, 'MAURÍCIA', 'MAURITIUS', NULL, 0, NULL),
            (160, 'MAURITÂNIA', 'MAURITANIA', NULL, 0, NULL),
            (161, 'MAYOTTE', 'MAYOTTE', NULL, 0, NULL),
            (162, 'MÉXICO', 'MEXICO', NULL, 0, NULL),
            (163, 'MIANMAR', 'MYANMAR BURMA', NULL, 0, NULL),
            (164, 'MICRONÉSIA', 'MICRONESIA', NULL, 0, NULL),
            (165, 'MOÇAMBIQUE', 'MOZAMBIQUE', NULL, 0, NULL),
            (166, 'MOLDÁVIA', 'MOLDOVA', NULL, 0, NULL),
            (167, 'MÓNACO', 'MONACO', NULL, 0, NULL),
            (168, 'MONGÓLIA', 'MONGOLIA', NULL, 0, NULL),
            (169, 'MONTENEGRO', 'MONTENEGRO', NULL, 0, NULL),
            (170, 'MONTSERRAT', 'MONTSERRAT', NULL, 0, NULL),
            (171, 'NAMÍBIA', 'NAMIBIA', NULL, 0, NULL),
            (172, 'NAURU', 'NAURU', NULL, 0, NULL),
            (173, 'NEPAL', 'NEPAL', NULL, 0, NULL),
            (174, 'NICARÁGUA', 'NICARAGUA', NULL, 0, NULL),
            (175, 'NÍGER', 'NIGER', NULL, 0, NULL),
            (176, 'NIGÉRIA', 'NIGERIA', NULL, 0, NULL),
            (177, 'NIUE', 'NIUE', NULL, 0, NULL),
            (178, 'NORUEGA', 'NORWAY', NULL, 0, NULL),
            (179, 'NOVA CALEDÓNIA', 'NEW CALEDONIA', NULL, 0, NULL),
            (180, 'NOVA ZELÂNDIA', 'NEW ZEALAND', NULL, 0, NULL),
            (181, 'OMÃ', 'OMAN', NULL, 0, NULL),
            (182, 'PAÍSES BAIXOS', 'NETHERLANDS', NULL, 0, NULL),
            (183, 'PALAU', 'PALAU', NULL, 0, NULL),
            (184, 'PALESTINA', 'PALESTINE', NULL, 0, NULL),
            (185, 'PANAMÁ', 'PANAMA', NULL, 0, NULL),
            (186, 'PAPUÁSIA-NOVA GUINÉ', 'PAPUA NEW GUINEA', NULL, 0, NULL),
            (187, 'PAQUISTÃO', 'PAKISTAN', NULL, 0, NULL),
            (188, 'PARAGUAI', 'PARAGUAY', NULL, 0, NULL),
            (189, 'PERU', 'PERU', NULL, 0, NULL),
            (190, 'POLINÉSIA FRANCESA', 'FRENCH POLYNESIA', NULL, 0, NULL),
            (191, 'POLÓNIA', 'POLAND', NULL, 0, NULL),
            (192, 'PORTO RICO', 'PUERTO RICO', NULL, 0, NULL),
            (193, 'PORTUGAL', 'PORTUGAL', '€', 1, 'Europe/Lisbon'),
            (194, 'QUÉNIA', 'KENYA', NULL, 0, NULL),
            (195, 'QUIRGUIZISTÃO', 'KYRGYZSTAN', NULL, 0, NULL),
            (196, 'REINO UNIDO', 'UNITED KINGDOM', NULL, 0, 'Europe/London'),
            (197, 'REPÚBLICA CHECA', 'CZECH REPUBLIC', NULL, 0, NULL),
            (198, 'REPÚBLICA DOMINICANA', 'DOMINICAN REPUBLIC', NULL, 0, NULL),
            (199, 'ROMÉNIA', 'ROMANIA', NULL, 0, NULL),
            (200, 'RUANDA', 'RWANDA', NULL, 0, NULL),
            (201, 'RÚSSIA', 'RUSSIAN FEDERATION', NULL, 0, NULL),
            (202, 'SAHARA OCCIDENTAL', 'WESTERN SAHARA', NULL, 0, NULL),
            (203, 'SALVADOR', 'EL SALVADOR', NULL, 0, NULL),
            (204, 'SAMOA', 'SAMOA', NULL, 0, NULL),
            (205, 'SANTA HELENA', 'SAINT HELENA', NULL, 0, NULL),
            (206, 'SANTA LÚCIA', 'SAINT LUCIA', NULL, 0, NULL),
            (207, 'SANTA SÉ', 'HOLY SEE', NULL, 0, NULL),
            (208, 'SÃO CRISTÓVÃO E NEVES', 'SAINT KITTS AND NEVIS', NULL, 0, NULL),
            (209, 'SÃO MARINO', 'SAN MARINO', NULL, 0, NULL),
            (210, 'SÃO PEDRO E MIQUELÃO', 'SAINT PIERRE AND MIQUELON', NULL, 0, NULL),
            (211, 'SÃO TOMÉ E PRÍNCIPE', 'SAO TOME AND PRINCIPE', NULL, 0, NULL),
            (212, 'SÃO VICENTE E GRANADINAS', 'SAINT VINCENT AND THE GRENADINES', NULL, 0, NULL),
            (213, 'SEICHELES', 'SEYCHELLES', NULL, 0, NULL),
            (214, 'SENEGAL', 'SENEGAL', NULL, 0, NULL),
            (215, 'SERRA LEOA', 'SIERRA LEONE', NULL, 0, NULL),
            (216, 'SÉRVIA', 'SERBIA', NULL, 0, NULL),
            (217, 'SINGAPURA', 'SINGAPORE', NULL, 0, NULL),
            (218, 'SÍRIA', 'SYRIA', NULL, 0, NULL),
            (219, 'SOMÁLIA', 'SOMALIA', NULL, 0, NULL),
            (220, 'SRI LANCA', 'SRI LANKA', NULL, 0, NULL),
            (221, 'SUAZILÂNDIA', 'SWAZILAND', NULL, 0, NULL),
            (222, 'SUDÃO', 'SUDAN', NULL, 0, NULL),
            (223, 'SUÉCIA', 'SWEDEN', NULL, 0, NULL),
            (224, 'SUÍÇA', 'SWITZERLAND', 'SFr', 1, 'Europe/Zurich'),
            (225, 'SURINAME', 'SURINAME', NULL, 0, NULL),
            (226, 'SVALBARD', 'SVALBARD', NULL, 0, NULL),
            (227, 'TAILÂNDIA', 'THAILAND', NULL, 0, NULL),
            (228, 'TAIWAN', 'TAIWAN', NULL, 0, NULL),
            (229, 'TAJIQUISTÃO', 'TAJIKISTAN', NULL, 0, NULL),
            (230, 'TANZÂNIA', 'TANZANIA', NULL, 0, NULL),
            (231, 'TERRITÓRIO BRITÂNICO DO OCEANO ÍNDICO', 'BRITISH INDIAN OCEAN TERRITORY', NULL, 0, NULL),
            (232, 'TERRITÓRIO DAS ILHAS HEARD E MCDONALD', 'HEARD ISLAND AND MCDONALD ISLANDS', NULL, 0, NULL),
            (233, 'TIMOR-LESTE', 'TIMOR-LESTE', NULL, 0, NULL),
            (234, 'TOGO', 'TOGO', NULL, 0, NULL),
            (235, 'TOKELAU', 'TOKELAU', NULL, 0, NULL),
            (236, 'TONGA', 'TONGA', NULL, 0, NULL),
            (237, 'TRINDADE E TOBAGO', 'TRINIDAD AND TOBAGO', NULL, 0, NULL),
            (238, 'TUNÍSIA', 'TUNISIA', NULL, 0, NULL),
            (239, 'TURKS E CAICOS', 'TURKS AND CAICOS ISLANDS', NULL, 0, NULL),
            (240, 'TURQUEMENISTÃO', 'TURKMENISTAN', NULL, 0, NULL),
            (241, 'TURQUIA', 'TURKEY', NULL, 0, NULL),
            (242, 'TUVALU', 'TUVALU', NULL, 0, NULL),
            (243, 'UCRÂNIA', 'UKRAINE', NULL, 0, NULL),
            (244, 'UGANDA', 'UGANDA', NULL, 0, NULL),
            (245, 'URUGUAI', 'URUGUAY', NULL, 0, NULL),
            (246, 'USBEQUISTÃO', 'UZBEKISTAN', NULL, 0, NULL),
            (247, 'VANUATU', 'VANUATU', NULL, 0, NULL),
            (248, 'VENEZUELA', 'VENEZUELA', NULL, 0, NULL),
            (249, 'VIETNAME', 'VIETNAM', NULL, 0, NULL),
            (250, 'WALLIS E FUTUNA', 'WALLIS AND FUTUNA', NULL, 0, NULL),
            (251, 'ZÂMBIA', 'ZAMBIA', NULL, 0, NULL),
            (252, 'ZIMBABUÉ', 'ZIMBABWE', NULL, 0, NULL)
        "));

        $this->command->info('Nivel de usuários inseridas!');
    }
    
}

class UserAdmin extends Seeder {

    public function run()
    {
        DB::table('user')->insert([
            'name' => 'Júnior',
            'nome' => 'Júnior',
            'last_name' => 'Mollo',
            'username' => 'Mollo',
            'email' => 'jrsherek@gmail.com',
            'password' => Hash::make('123'),
            'passwd' => Hash::make('123'),
            'nivel' => '3',
            'telefone' => '16993781194',
            'cadastro' => date ('Y-m-d H:i:s'),
            'id_apoio' => 1,
            'porcentagem' => 0,
            'id_pais' => 33,
            'data_corte' => date ('Y-m-d H:i:s'),
            'validade' => '0',
            'revalidar' => '0',
            'data_validacao' =>  date ('Y-m-d H:i:s'),
            'status' => '1',
            'afiliado' => '0',
            'fechar_faturas_ponto' => '0',
            'cpf' => '111111111',
            'chave_pix' => 'dmfpdsaf'
           
        ]);        

        $this->command->info('User admin criado!');
    }
}
