<?php

use Illuminate\Support\Facades\Route;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/
Route::get('/', 'PrincipalController@home');

Route::get('/login', 'LoginController@login')->name('login');

Route::get('/login/logout', 'LoginController@logout')->name('logout');

Route::post('/login/autorizar', 'LoginController@autorizar');

Route::get('/home', 'PrincipalController@home')->name('home');

Route::get('/cadastro/{id}', 'PrincipalController@cadastrar')->name('cadastrar');

Route::post('/cadastro/salvar', 'PrincipalController@salvar');



Route::middleware('auth:cliente')->group(function(){
Route::prefix('cliente')->group(function(){

    Route::get('/', 'ClienteController@index')->name('home');
    Route::get('/cliente', 'ClienteController@dados');
    Route::post('/gerar-pix', 'PixController@gerarPix');
    
    });

});

Route::get('/adm/clientes/form-lista', 'PrincipalController@formCliente');

Route::get('/adm/clientes/listar', 'PrincipalController@listarCliente');

Route::get('/adm/form-cad', 'PrincipalController@formCad');

Route::post('/adm/clientes/salvar', 'PrincipalController@update');

//Rota para limpar cache
Route::get('/limpar-cache', function(){
      \Artisan::call('config:clear');

      // Limpar cache de configuração e recarregar
      \Artisan::call('config:cache');

      // Limpar cache da aplicação
      \Artisan::call('cache:clear');

      // Limpar cache de rotas
      \Artisan::call('route:clear');

      // Limpar cache de visualizações
      \Artisan::call('view:clear');
      echo "Pronto";
});

Route::post('/webhook', 'PixController@webhook');

Route::post('/pix', 'PixController@webhookPix');

Route::get('/noti', 'PixController@notification');

Route::get('/configWH', 'PixController@configWebHook');

Route::get('/configNF', 'PixController@configNotification');